/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import java.util.Collection;

public abstract class CascadingStats {
    Status status = Status.PENDING;
    long startTime;
    long finishedTime;
    Throwable throwable;

    CascadingStats() {
    }

    public abstract Object getID();

    public boolean isFinished() {
        return this.status == Status.SUCCESSFUL || this.status == Status.FAILED || this.status == Status.STOPPED;
    }

    public boolean isPending() {
        return this.status == Status.PENDING;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isSuccessful() {
        return this.status == Status.SUCCESSFUL;
    }

    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public Status getStatus() {
        return this.status;
    }

    public void markRunning() {
        if (this.status != Status.PENDING) {
            throw new IllegalStateException("may not mark flow as " + (Object)((Object)Status.RUNNING) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.RUNNING;
        this.markStartTime();
    }

    protected void markStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void markSuccessful() {
        if (this.status != Status.RUNNING) {
            throw new IllegalStateException("may not mark flow as " + (Object)((Object)Status.SUCCESSFUL) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.SUCCESSFUL;
        this.markFinishedTime();
    }

    private void markFinishedTime() {
        this.finishedTime = System.currentTimeMillis();
    }

    public void markFailed(Throwable throwable) {
        if (this.status != Status.RUNNING) {
            throw new IllegalStateException("may not mark flow as " + (Object)((Object)Status.FAILED) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.FAILED;
        this.markFinishedTime();
        this.throwable = throwable;
    }

    public void markStopped() {
        if (this.status != Status.RUNNING) {
            throw new IllegalStateException("may not mark flow as " + (Object)((Object)Status.STOPPED) + ", is already " + (Object)((Object)this.status));
        }
        this.status = Status.STOPPED;
        this.markFinishedTime();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getDuration() {
        if (this.finishedTime != 0L) {
            return this.finishedTime - this.startTime;
        }
        return 0L;
    }

    public abstract long getCounterValue(Enum var1);

    public abstract long getCounterValue(String var1, String var2);

    public abstract void captureDetail();

    public abstract Collection getChildren();

    protected String getStatsString() {
        String string = "status=" + (Object)((Object)this.status) + ", startTime=" + this.startTime;
        if (this.finishedTime != 0L) {
            string = string + ", duration=" + (this.finishedTime - this.startTime);
        }
        return string;
    }

    public String toString() {
        return "Cascading{" + this.getStatsString() + '}';
    }

    public static enum Status {
        PENDING,
        RUNNING,
        SUCCESSFUL,
        FAILED,
        STOPPED;

    }
}

