/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats;

import cascading.stats.CascadingStats;
import cascading.stats.FlowStats;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class CascadeStats
extends CascadingStats {
    String cascadeID;
    List<FlowStats> flowStatsList = new LinkedList<FlowStats>();

    public CascadeStats(String cascadeID) {
        this.cascadeID = cascadeID;
    }

    @Override
    public Object getID() {
        return this.cascadeID;
    }

    public void addFlowStats(FlowStats flowStats) {
        this.flowStatsList.add(flowStats);
    }

    public int getFlowCount() {
        return this.flowStatsList.size();
    }

    @Override
    public long getCounterValue(Enum counter) {
        long value = 0L;
        for (FlowStats flowStats : this.flowStatsList) {
            value += flowStats.getCounterValue(counter);
        }
        return value;
    }

    @Override
    public long getCounterValue(String group, String counter) {
        long value = 0L;
        for (FlowStats flowStats : this.flowStatsList) {
            value += flowStats.getCounterValue(group, counter);
        }
        return value;
    }

    @Override
    public void captureDetail() {
        for (FlowStats flowStats : this.flowStatsList) {
            flowStats.captureDetail();
        }
    }

    @Override
    public Collection getChildren() {
        return this.flowStatsList;
    }

    @Override
    public String toString() {
        return "Cascade{flowStatsList=" + this.flowStatsList + '}';
    }
}

