/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme;

import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.hadoop.ZipInputFormat;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class TextLine
extends Scheme {
    private static final long serialVersionUID = 1L;
    public static final Fields DEFAULT_SOURCE_FIELDS = new Fields(new Comparable[]{"offset", "line"});
    Compress sinkCompression = Compress.DISABLE;

    public TextLine() {
        super(DEFAULT_SOURCE_FIELDS);
    }

    @ConstructorProperties(value={"numSinkParts"})
    public TextLine(int numSinkParts) {
        super(DEFAULT_SOURCE_FIELDS, numSinkParts);
    }

    @ConstructorProperties(value={"sinkCompression"})
    public TextLine(Compress sinkCompression) {
        super(DEFAULT_SOURCE_FIELDS);
        this.sinkCompression = sinkCompression;
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields"})
    public TextLine(Fields sourceFields, Fields sinkFields) {
        super(sourceFields, sinkFields);
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "numSinkParts"})
    public TextLine(Fields sourceFields, Fields sinkFields, int numSinkParts) {
        super(sourceFields, sinkFields, numSinkParts);
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression) {
        super(sourceFields, sinkFields);
        this.sinkCompression = sinkCompression;
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "numSinkParts"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression, int numSinkParts) {
        super(sourceFields, sinkFields, numSinkParts);
        this.sinkCompression = sinkCompression;
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    @ConstructorProperties(value={"sourceFields"})
    public TextLine(Fields sourceFields) {
        super(sourceFields);
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    @ConstructorProperties(value={"sourceFields", "numSinkParts"})
    public TextLine(Fields sourceFields, int numSinkParts) {
        super(sourceFields, numSinkParts);
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    public Compress getSinkCompression() {
        return this.sinkCompression;
    }

    public void setSinkCompression(Compress sinkCompression) {
        this.sinkCompression = sinkCompression;
    }

    @Override
    public void sourceInit(Tap tap, JobConf conf) {
        if (this.hasZippedFiles(FileInputFormat.getInputPaths((JobConf)conf))) {
            conf.setInputFormat(ZipInputFormat.class);
        } else {
            conf.setInputFormat(TextInputFormat.class);
        }
    }

    private boolean hasZippedFiles(Path[] paths) {
        boolean isZipped = paths[0].getName().endsWith(".zip");
        for (int i = 1; i < paths.length; ++i) {
            if (isZipped == paths[i].getName().endsWith(".zip")) continue;
            throw new IllegalStateException("cannot mix zipped and upzippled files");
        }
        return isZipped;
    }

    @Override
    public void sinkInit(Tap tap, JobConf conf) throws IOException {
        if (tap.getQualifiedPath(conf).toString().endsWith(".zip")) {
            throw new IllegalStateException("cannot write zip files: " + FileOutputFormat.getOutputPath((JobConf)conf));
        }
        if (this.getSinkCompression() == Compress.DISABLE) {
            conf.setBoolean("mapred.output.compress", false);
        } else if (this.getSinkCompression() == Compress.ENABLE) {
            conf.setBoolean("mapred.output.compress", true);
        }
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
    }

    @Override
    public Tuple source(Object key, Object value) {
        Tuple tuple = new Tuple();
        if (this.sourceFields.size() == 2) {
            tuple.add(key.toString());
        }
        tuple.add(value.toString());
        return tuple;
    }

    @Override
    public void sink(TupleEntry tupleEntry, OutputCollector outputCollector) throws IOException {
        outputCollector.collect(null, (Object)tupleEntry.selectTuple(this.sinkFields));
    }

    public static enum Compress {
        DEFAULT,
        ENABLE,
        DISABLE;

    }
}

