/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme;

import cascading.scheme.TextLine;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.OutputCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDelimited
extends TextLine {
    private static final Logger LOG = LoggerFactory.getLogger(TextDelimited.class);
    private static final String QUOTED_REGEX_FORMAT = "%2$s(?!(?:[^%1$s%2$s]|[^%1$s]%2$s[^%1$s])+%1$s)";
    private static final String CLEAN_REGEX_FORMAT = "^(?:%1$s)(.*)(?:%1$s)$";
    private static final String ESCAPE_REGEX_FORMAT = "(%1$s%1$s)";
    protected Pattern splitPattern;
    protected Pattern cleanPattern;
    protected Pattern escapePattern;
    private boolean skipHeader;
    private String delimiter;
    private String quote;
    private boolean strict = true;
    private int numValues;
    private Class[] types;
    private boolean safe = true;
    private Object[] buffer;

    @ConstructorProperties(value={"fields", "delimiter"})
    public TextDelimited(Fields fields, String delimiter) {
        this(fields, null, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "delimiter"})
    public TextDelimited(Fields fields, boolean skipHeader, String delimiter) {
        this(fields, null, skipHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter", "types"})
    public TextDelimited(Fields fields, String delimiter, Class[] types) {
        this(fields, null, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, boolean skipHeader, String delimiter, Class[] types) {
        this(fields, null, skipHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, String delimiter, String quote, Class[] types) {
        this(fields, null, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, boolean skipHeader, String delimiter, String quote, Class[] types) {
        this(fields, null, skipHeader, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, boolean skipHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, skipHeader, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter) {
        this(fields, sinkCompression, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, String delimiter) {
        this(fields, sinkCompression, skipHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, Class[] types) {
        this(fields, sinkCompression, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, String delimiter, Class[] types) {
        this(fields, sinkCompression, skipHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote"})
    public TextDelimited(Fields fields, String delimiter, String quote) {
        this(fields, null, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, boolean skipHeader, String delimiter, String quote) {
        this(fields, null, skipHeader, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote) {
        this(fields, sinkCompression, false, delimiter, true, quote, null, true);
    }

    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, String delimiter, String quote) {
        this(fields, sinkCompression, skipHeader, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, false, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, skipHeader, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, false, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "strict", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, String delimiter, boolean strict, String quote, Class[] types, boolean safe) {
        super(sinkCompression);
        this.setSinkFields(fields);
        this.setSourceFields(fields);
        this.skipHeader = skipHeader;
        this.delimiter = delimiter;
        this.strict = strict;
        this.safe = safe;
        this.numValues = fields.size();
        if (this.numValues == 0) {
            throw new IllegalArgumentException("may not be zero declared fields, found: " + fields.printVerbose());
        }
        if (quote != null && !quote.isEmpty()) {
            this.quote = quote;
        }
        this.splitPattern = this.quote == null ? Pattern.compile(delimiter) : Pattern.compile(String.format(QUOTED_REGEX_FORMAT, this.quote, delimiter));
        if (this.quote != null) {
            this.cleanPattern = Pattern.compile(String.format(CLEAN_REGEX_FORMAT, this.quote));
            this.escapePattern = Pattern.compile(String.format(ESCAPE_REGEX_FORMAT, this.quote));
        }
        if (types != null && types.length == 0) {
            this.types = null;
        }
        if (types != null) {
            this.types = Arrays.copyOf(types, types.length);
        }
        if (types != null && types.length != fields.size()) {
            throw new IllegalArgumentException("num of types must equal number of fields: " + fields.printVerbose() + ", found: " + types.length);
        }
    }

    @Override
    public Tuple source(Object key, Object value) {
        int i;
        if (this.skipHeader && ((LongWritable)key).get() == 0L) {
            return null;
        }
        Object[] split = this.splitPattern.split(value.toString(), this.numValues);
        if (this.strict && split.length != this.numValues) {
            throw new TapException("did not parse correct number of values from input data, expected: " + this.numValues + ", got: " + split.length + ":" + Util.join(",", (String[])split));
        }
        if (this.cleanPattern != null) {
            for (i = 0; i < split.length; ++i) {
                split[i] = this.cleanPattern.matcher(split[i]).replaceAll("$1");
                split[i] = this.escapePattern.matcher((String)split[i]).replaceAll(this.quote);
            }
        }
        for (i = 0; i < split.length; ++i) {
            if (!split[i].isEmpty()) continue;
            split[i] = null;
        }
        if (this.types != null) {
            Object[] result = new Object[split.length];
            for (int i2 = 0; i2 < split.length; ++i2) {
                try {
                    result[i2] = Tuples.coerce(split[i2], this.types[i2]);
                    continue;
                }
                catch (Exception exception) {
                    String message = "field " + this.getSourceFields().get(i2) + " cannot be coerced from : " + result[i2] + " to: " + this.types[i2].getName();
                    result[i2] = null;
                    LOG.warn(message, (Throwable)exception);
                    if (this.safe) continue;
                    throw new TapException(message, exception);
                }
            }
            split = result;
        }
        return new Tuple(split);
    }

    private Object[] getBuffer(Tuple tuple) {
        if (this.buffer == null) {
            this.buffer = new Object[tuple.size()];
        }
        return this.buffer;
    }

    @Override
    public void sink(TupleEntry tupleEntry, OutputCollector outputCollector) throws IOException {
        Tuple tuple = tupleEntry.selectTuple(this.sinkFields);
        Object[] buffer = Tuples.asArray(tuple, this.getBuffer(tuple));
        if (this.quote != null) {
            for (int i = 0; i < buffer.length; ++i) {
                Object value = buffer[i];
                if (value == null) continue;
                String valueString = value.toString();
                if (valueString.contains(this.quote)) {
                    valueString = valueString.replaceAll(this.quote, this.quote + this.quote);
                }
                if (valueString.contains(this.delimiter)) {
                    valueString = this.quote + valueString + this.quote;
                }
                buffer[i] = valueString;
            }
        }
        outputCollector.collect(null, (Object)Util.join(buffer, this.delimiter, false));
    }
}

