/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.cogroup;

import cascading.pipe.cogroup.GroupClosure;
import cascading.pipe.cogroup.Joiner;
import cascading.tuple.Tuple;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class InnerJoin
implements Joiner {
    private static final Logger LOG = Logger.getLogger(InnerJoin.class);

    @Override
    public Iterator<Tuple> getIterator(GroupClosure closure) {
        return new JoinIterator(closure);
    }

    @Override
    public int numJoins() {
        return -1;
    }

    protected static class JoinIterator
    implements Iterator<Tuple> {
        final GroupClosure closure;
        Iterator[] iterators;
        Comparable[] lastValues;

        public JoinIterator(GroupClosure closure) {
            this.closure = closure;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cogrouped size: " + closure.size()));
            }
            this.init();
        }

        protected void init() {
            this.iterators = new Iterator[this.closure.size()];
            for (int i = 0; i < this.closure.size(); ++i) {
                this.iterators[i] = this.getIterator(i);
            }
        }

        protected Iterator getIterator(int i) {
            return this.closure.getIterator(i);
        }

        private Comparable[] initLastValues() {
            this.lastValues = new Comparable[this.iterators.length];
            for (int i = 0; i < this.iterators.length; ++i) {
                this.lastValues[i] = (Comparable)this.iterators[i].next();
            }
            return this.lastValues;
        }

        @Override
        public final boolean hasNext() {
            if (this.lastValues == null) {
                for (Iterator iterator : this.iterators) {
                    if (iterator.hasNext()) continue;
                    return false;
                }
                return true;
            }
            for (Iterator iterator : this.iterators) {
                if (!iterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Tuple next() {
            if (this.lastValues == null) {
                return this.makeResult(this.initLastValues());
            }
            for (int i = this.iterators.length - 1; i >= 0; --i) {
                if (this.iterators[i].hasNext()) {
                    this.lastValues[i] = (Comparable)this.iterators[i].next();
                    break;
                }
                this.iterators[i] = this.getIterator(i);
                this.lastValues[i] = (Comparable)this.iterators[i].next();
            }
            return this.makeResult(this.lastValues);
        }

        private Tuple makeResult(Comparable[] lastValues) {
            Tuple result = new Tuple();
            for (Comparable lastValue : lastValues) {
                result.addAll(lastValue);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("tuple: " + result.print()));
            }
            return result;
        }

        @Override
        public void remove() {
        }
    }
}

