/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe;

import cascading.CascadingException;
import cascading.flow.FlowCollector;
import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.operation.Assertion;
import cascading.operation.AssertionLevel;
import cascading.operation.ConcreteCall;
import cascading.operation.Debug;
import cascading.operation.DebugLevel;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.Operation;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.operation.ValueAssertion;
import cascading.pipe.Operator;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.apache.log4j.Logger;

public class Each
extends Operator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Each.class);
    private static final Fields FUNCTION_SELECTOR = Fields.RESULTS;
    private static final Fields FILTER_SELECTOR = Fields.RESULTS;

    @ConstructorProperties(value={"name", "function"})
    public Each(String name, Function function) {
        super(name, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "function"})
    public Each(String name, Fields argumentSelector, Function function) {
        super(name, argumentSelector, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "function", "outputSelector"})
    public Each(String name, Fields argumentSelector, Function function, Fields outputSelector) {
        super(name, argumentSelector, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"name", "function", "outputSelector"})
    public Each(String name, Function function, Fields outputSelector) {
        super(name, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"previous", "function"})
    public Each(Pipe previous, Function function) {
        super(previous, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"previoud", "argumentSelector", "function"})
    public Each(Pipe previous, Fields argumentSelector, Function function) {
        super(previous, argumentSelector, (Operation)function, FUNCTION_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "function", "outputSelector"})
    public Each(Pipe previous, Fields argumentSelector, Function function, Fields outputSelector) {
        super(previous, argumentSelector, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"previous", "function", "outputSelector"})
    public Each(Pipe previous, Function function, Fields outputSelector) {
        super(previous, (Operation)function, outputSelector);
    }

    @ConstructorProperties(value={"name", "filter"})
    public Each(String name, Filter filter) {
        super(name, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "filter"})
    public Each(String name, Fields argumentSelector, Filter filter) {
        super(name, argumentSelector, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "filter"})
    public Each(Pipe previous, Filter filter) {
        super(previous, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "filter"})
    public Each(Pipe previous, Fields argumentSelector, Filter filter) {
        super(previous, argumentSelector, (Operation)filter, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "assertionLevel", "assertion"})
    public Each(String name, AssertionLevel assertionLevel, Assertion assertion) {
        super(name, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "assertionLevel", "assertion"})
    public Each(String name, Fields argumentSelector, AssertionLevel assertionLevel, Assertion assertion) {
        super(name, argumentSelector, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "assertionLevel", "assertion"})
    public Each(Pipe previous, AssertionLevel assertionLevel, Assertion assertion) {
        super(previous, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "assertionLevel", "assertion"})
    public Each(Pipe previous, Fields argumentSelector, AssertionLevel assertionLevel, Assertion assertion) {
        super(previous, argumentSelector, (PlannerLevel)assertionLevel, (PlannedOperation)assertion, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"name", "argumentSelector", "debugLevel", "debug"})
    public Each(String name, Fields argumentSelector, DebugLevel debugLevel, Debug debug) {
        super(name, argumentSelector, (PlannerLevel)debugLevel, (PlannedOperation)debug, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "debuglevel", "debug"})
    public Each(Pipe previous, DebugLevel debugLevel, Debug debug) {
        super(previous, (PlannerLevel)debugLevel, (PlannedOperation)debug, FILTER_SELECTOR);
    }

    @ConstructorProperties(value={"previous", "argumentSelector", "debugLevel", "debug"})
    public Each(Pipe previous, Fields argumentSelector, DebugLevel debugLevel, Debug debug) {
        super(previous, argumentSelector, (PlannerLevel)debugLevel, (PlannedOperation)debug, FILTER_SELECTOR);
    }

    @Override
    protected void verifyOperation() {
        if (this.plannerLevel == null && this.operation instanceof Debug) {
            this.plannerLevel = DebugLevel.DEFAULT;
        }
        super.verifyOperation();
        if (!this.argumentSelector.isArgSelector()) {
            throw new IllegalArgumentException("invalid argument selector: " + this.argumentSelector);
        }
        if (!this.operation.getFieldDeclaration().isDeclarator()) {
            throw new IllegalArgumentException("invalid field declaration: " + this.operation.getFieldDeclaration());
        }
        if (!this.outputSelector.isOutSelector()) {
            throw new IllegalArgumentException("invalid output selector: " + this.outputSelector);
        }
    }

    private Function getFunction() {
        return (Function)this.operation;
    }

    private Filter getFilter() {
        return (Filter)this.operation;
    }

    private ValueAssertion getValueAssertion() {
        return (ValueAssertion)this.operation;
    }

    private boolean isFunction() {
        return this.operation instanceof Function;
    }

    private boolean isFilter() {
        return this.operation instanceof Filter;
    }

    private void applyAssertion(FlowProcess flowProcess, FlowCollector flowCollector, TupleEntry input, ConcreteCall operationCall) {
        this.getValueAssertion().doAssert(flowProcess, operationCall);
        flowCollector.collect(input.getTuple());
    }

    private void applyFilter(FlowProcess flowProcess, FlowCollector flowCollector, TupleEntry input, FilterCall filterCall) {
        boolean isRemove = false;
        isRemove = this.getFilter().isRemove(flowProcess, filterCall);
        if (!isRemove) {
            flowCollector.collect(input.getTuple());
        }
    }

    private void applyFunction(FlowProcess flowProcess, FunctionCall functionCall) {
        this.getFunction().operate(flowProcess, functionCall);
    }

    private Fields getFieldsFor(Scope incomingScope) {
        if (incomingScope.isEvery()) {
            return incomingScope.getOutGroupingFields();
        }
        return incomingScope.getOutValuesFields();
    }

    @Override
    public Fields resolveIncomingOperationFields(Scope incomingScope) {
        return this.getFieldsFor(incomingScope);
    }

    @Override
    public Fields resolveFields(Scope scope) {
        return this.getFieldsFor(scope);
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields argumentFields = this.resolveArgumentSelector(incomingScopes);
        this.verifyArguments(argumentFields);
        Fields declaredFields = this.resolveDeclared(incomingScopes, argumentFields);
        this.verifyDeclaredFields(declaredFields);
        Fields outgoingValuesFields = this.resolveOutgoingValuesSelector(incomingScopes, argumentFields, declaredFields);
        this.verifyOutputSelector(outgoingValuesFields);
        Fields outgoingGroupingFields = Fields.asDeclaration(outgoingValuesFields);
        Fields remainderFields = this.resolveRemainderFields(incomingScopes, argumentFields);
        return new Scope(this.getName(), Scope.Kind.EACH, remainderFields, argumentFields, declaredFields, outgoingGroupingFields, outgoingValuesFields);
    }

    Fields resolveOutgoingValuesSelector(Set<Scope> incomingScopes, Fields argumentFields, Fields declaredFields) {
        try {
            return this.resolveOutgoingSelector(incomingScopes, argumentFields, declaredFields);
        }
        catch (Exception exception) {
            if (exception instanceof OperatorException) {
                throw (OperatorException)exception;
            }
            throw new OperatorException(this, "could not resolve outgoing values selector in: " + this, exception);
        }
    }

    public EachHandler getHandler(FlowCollector flowCollector, Scope scope) {
        if (this.isFunction()) {
            return new EachFunctionHandler(flowCollector, scope);
        }
        if (this.isFilter()) {
            return new EachFilterHandler(flowCollector, scope);
        }
        return new EachAssertionHandler(flowCollector, scope);
    }

    public class EachAssertionHandler
    extends EachHandler {
        public EachAssertionHandler(FlowCollector flowCollector, Scope scope) {
            super(flowCollector, scope);
        }

        @Override
        void handle(FlowProcess flowProcess, TupleEntry input, TupleEntry arguments) {
            this.operationCall.setArguments(arguments);
            Each.this.applyAssertion(flowProcess, this.flowCollector, input, this.operationCall);
        }
    }

    public class EachFilterHandler
    extends EachHandler {
        public EachFilterHandler(FlowCollector flowCollector, Scope scope) {
            super(flowCollector, scope);
        }

        @Override
        void handle(FlowProcess flowProcess, TupleEntry input, TupleEntry arguments) {
            this.operationCall.setArguments(arguments);
            Each.this.applyFilter(flowProcess, this.flowCollector, input, this.operationCall);
        }
    }

    public class EachFunctionHandler
    extends EachHandler {
        EachTupleCollector tupleCollector;

        public EachFunctionHandler(final FlowCollector flowCollector, Scope scope) {
            super(flowCollector, scope);
            this.tupleCollector = new EachTupleCollector(scope.getDeclaredEntry().getFields(), scope){

                @Override
                protected void collect(Tuple tuple) {
                    flowCollector.collect(Each.this.makeResult(this.scope.getOutValuesSelector(), this.input, this.scope.getRemainderFields(), this.scope.getDeclaredEntry(), tuple));
                }
            };
            this.operationCall.setOutputCollector(this.tupleCollector);
        }

        @Override
        void handle(FlowProcess flowProcess, TupleEntry input, TupleEntry arguments) {
            this.tupleCollector.input = input;
            this.operationCall.setArguments(arguments);
            Each.this.applyFunction(flowProcess, this.operationCall);
        }

        private abstract class EachTupleCollector
        extends TupleEntryCollector {
            Scope scope;
            TupleEntry input;

            private EachTupleCollector(Fields fields, Scope scope) {
                super(fields);
                this.scope = scope;
            }
        }
    }

    public abstract class EachHandler {
        FlowCollector flowCollector;
        final Scope scope;
        protected ConcreteCall operationCall;

        protected EachHandler(FlowCollector flowCollector, Scope scope) {
            this.flowCollector = flowCollector;
            this.scope = scope;
            this.operationCall = new ConcreteCall(scope.getArguments());
        }

        public void operate(FlowProcess flowProcess, TupleEntry input) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(Each.this.operation + " incoming entry: " + input));
                }
                TupleEntry arguments = this.scope.getArgumentsEntry(input);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(Each.this.operation + " arg entry: " + arguments));
                }
                this.handle(flowProcess, input, arguments);
            }
            catch (CascadingException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                throw new OperatorException(Each.this, "operator Each failed executing operation", exception);
            }
        }

        abstract void handle(FlowProcess var1, TupleEntry var2, TupleEntry var3);

        public FlowElement getEach() {
            return Each.this;
        }

        public void prepare(FlowProcess flowProcess) {
            Each.this.getOperation().prepare(flowProcess, this.operationCall);
        }

        public void cleanup(FlowProcess flowProcess) {
            Each.this.getOperation().cleanup(flowProcess, this.operationCall);
        }
    }
}

