/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.regex;

import cascading.flow.FlowProcess;
import cascading.operation.OperationCall;
import cascading.operation.regex.RegexOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class RegexMatcher
extends RegexOperation<Matcher> {
    private static final Logger LOG = Logger.getLogger(RegexMatcher.class);
    protected final boolean negateMatch;

    @ConstructorProperties(value={"patternString"})
    protected RegexMatcher(String patternString) {
        super(patternString);
        this.negateMatch = false;
    }

    @ConstructorProperties(value={"patternString", "negateMatch"})
    protected RegexMatcher(String patternString, boolean negateMatch) {
        super(patternString);
        this.negateMatch = negateMatch;
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = false;
        this.verify();
    }

    @ConstructorProperties(value={"fieldDeclaration", "patternString", "negateMatch"})
    protected RegexMatcher(Fields fieldDeclaration, String patternString, boolean negateMatch) {
        super(Integer.MAX_VALUE, fieldDeclaration, patternString);
        this.negateMatch = negateMatch;
        this.verify();
    }

    private void verify() {
        if (this.fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("num fields in fieldDeclaration must be one, found: " + this.fieldDeclaration.printVerbose());
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Matcher> operationCall) {
        operationCall.setContext(this.getPattern().matcher(""));
    }

    protected boolean matchWholeTuple(Matcher matcher, Tuple input) {
        matcher.reset(input.toString("\t"));
        boolean matchFound = matcher.find();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pattern: " + this.getPattern() + ", matches: " + matchFound));
        }
        return matchFound == this.negateMatch;
    }

    protected boolean matchEachElement(Matcher matcher, Tuple input) {
        return this.matchEachElementPos(matcher, input) != -1;
    }

    protected int matchEachElementPos(Matcher matcher, Tuple input) {
        int pos = 0;
        for (Object value : input) {
            if (value == null) {
                value = "";
            }
            matcher.reset(value.toString());
            boolean matchFound = matcher.find();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pattern: " + this.getPattern() + ", matches: " + matchFound + ", element: '" + value + "'"));
            }
            if (matchFound == this.negateMatch) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }
}

