/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import java.beans.ConstructorProperties;

public class Limit
extends BaseOperation<Context>
implements Filter<Context> {
    private long limit = 0L;

    @ConstructorProperties(value={"limit"})
    public Limit(long limit) {
        this.limit = limit;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        super.prepare(flowProcess, operationCall);
        Context context = new Context();
        operationCall.setContext(context);
        HadoopFlowProcess process = (HadoopFlowProcess)flowProcess;
        int numTasks = 0;
        numTasks = process.isMapper() ? process.getCurrentNumMappers() : process.getCurrentNumReducers();
        int taskNum = process.getCurrentTaskNum();
        context.limit = (long)Math.floor((double)this.limit / (double)numTasks);
        long remainingLimit = this.limit % (long)numTasks;
        context.limit = context.limit + ((long)taskNum < remainingLimit ? 1L : 0L);
    }

    @Override
    public boolean isRemove(FlowProcess flowProcess, FilterCall<Context> filterCall) {
        return ((Context)filterCall.getContext()).increment();
    }

    public static class Context {
        public long limit = 0L;
        public long count = 0L;

        public boolean increment() {
            if (this.limit == this.count) {
                return true;
            }
            ++this.count;
            return false;
        }
    }
}

