/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.assertion;

import cascading.flow.FlowProcess;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.BaseAssertion;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;

public class AssertEqualsAll
extends BaseAssertion
implements ValueAssertion {
    private Object value;

    @ConstructorProperties(value={"value"})
    public AssertEqualsAll(Object value) {
        super("argument '%s' value was: %s, not: %s, in tuple: %s");
        if (value == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        this.value = value;
    }

    public void doAssert(FlowProcess flowProcess, ValueAssertionCall assertionCall) {
        TupleEntry input = assertionCall.getArguments();
        int pos = 0;
        for (Object element : input.getTuple()) {
            if (!this.value.equals(element)) {
                this.fail(input.getFields().get(pos), element, this.value, input.getTuple().print());
            }
            ++pos;
        }
    }
}

