/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.aggregator;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;

public class Average
extends BaseOperation<Context>
implements Aggregator<Context> {
    public static final String FIELD_NAME = "average";

    public Average() {
        super(1, new Fields(new Comparable[]{FIELD_NAME}));
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public Average(Fields fieldDeclaration) {
        super(1, fieldDeclaration);
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare 1 field, got: " + fieldDeclaration.size());
        }
    }

    @Override
    public void start(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        if (aggregatorCall.getContext() != null) {
            ((Context)aggregatorCall.getContext()).reset();
        } else {
            aggregatorCall.setContext(new Context());
        }
    }

    @Override
    public void aggregate(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        Context context = (Context)aggregatorCall.getContext();
        TupleEntry arguments = aggregatorCall.getArguments();
        context.sum += arguments.getDouble(Integer.valueOf(0));
        context.count = (long)((double)context.count + 1.0);
    }

    @Override
    public void complete(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        aggregatorCall.getOutputCollector().add(this.getResult(aggregatorCall));
    }

    private Tuple getResult(AggregatorCall<Context> aggregatorCall) {
        Context context = (Context)aggregatorCall.getContext();
        return new Tuple(Double.valueOf(context.sum) / (double)context.count);
    }

    protected static class Context {
        double sum = 0.0;
        long count = 0L;

        protected Context() {
        }

        public Context reset() {
            this.sum = 0.0;
            this.count = 0L;
            return this;
        }
    }
}

