/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation;

import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.operation.Assertion;
import cascading.operation.Filter;
import cascading.operation.Operation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.util.Util;
import java.io.Serializable;

public abstract class BaseOperation<C>
implements Serializable,
Operation<C> {
    protected Fields fieldDeclaration;
    protected int numArgs = Integer.MAX_VALUE;
    protected String trace = Util.captureDebugTrace(this.getClass());

    protected BaseOperation() {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
    }

    protected BaseOperation(Fields fieldDeclaration) {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
        this.fieldDeclaration = fieldDeclaration;
        this.verify();
    }

    protected BaseOperation(int numArgs) {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
        this.numArgs = numArgs;
        this.verify();
    }

    protected BaseOperation(int numArgs, Fields fieldDeclaration) {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
        this.numArgs = numArgs;
        this.fieldDeclaration = fieldDeclaration;
        this.verify();
    }

    private final void verify() {
        if (this instanceof Filter && this.fieldDeclaration != Fields.ALL) {
            throw new IllegalArgumentException("fieldDeclaration must be set to Fields.ALL for filter operations");
        }
        if (this instanceof Assertion && this.fieldDeclaration != Fields.ALL) {
            throw new IllegalArgumentException("fieldDeclaration must be set to Fields.ALL for assertion operations");
        }
        if (this.fieldDeclaration == null) {
            throw new IllegalArgumentException("fieldDeclaration may not be null");
        }
        if (this.numArgs < 0) {
            throw new IllegalArgumentException("numArgs may not be negative");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<C> operationCall) {
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall<C> operationCall) {
    }

    @Override
    public Fields getFieldDeclaration() {
        return this.fieldDeclaration;
    }

    @Override
    public int getNumArgs() {
        return this.numArgs;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    public String getTrace() {
        return this.trace;
    }

    public String toString() {
        return BaseOperation.toStringInternal(this);
    }

    public static String toStringInternal(Operation operation) {
        StringBuilder buffer = new StringBuilder();
        Class<?> type = operation.getClass();
        if (type.getSimpleName().length() != 0) {
            buffer.append(type.getSimpleName());
        } else {
            buffer.append(type.getName());
        }
        if (operation.getFieldDeclaration() != null) {
            buffer.append("[decl:").append(operation.getFieldDeclaration()).append("]");
        }
        if (operation.getNumArgs() != Integer.MAX_VALUE) {
            buffer.append("[args:").append(operation.getNumArgs()).append("]");
        }
        return buffer.toString();
    }

    public static void printOperationInternal(Operation operation, StringBuffer buffer, Scope scope) {
        Class<?> type = operation.getClass();
        if (type.getSimpleName().length() != 0) {
            buffer.append(type.getSimpleName());
        } else {
            buffer.append(type.getName());
        }
        if (scope.getDeclaredFields() != null) {
            buffer.append("[decl:").append(scope.getDeclaredFields()).append("]");
        }
        if (operation.getNumArgs() != Integer.MAX_VALUE) {
            buffer.append("[args:").append(operation.getNumArgs()).append("]");
        }
    }
}

