/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.CascadingException;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.StepCounters;
import cascading.flow.stack.MapperStackElement;
import cascading.flow.stack.StackException;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import java.io.IOException;

class SourceMapperStackElement
extends MapperStackElement {
    private final Tap source;

    public SourceMapperStackElement(FlowProcess flowProcess, Scope incomingScope, String trapName, Tap trap, Tap source) throws IOException {
        super(flowProcess, incomingScope, trapName, trap);
        this.source = source;
    }

    public SourceMapperStackElement(FlowProcess flowProcess, Scope incomingScope, Tap source) throws IOException {
        super(flowProcess, incomingScope, null, null);
        this.source = source;
    }

    @Override
    protected FlowElement getFlowElement() {
        return this.source;
    }

    @Override
    public Tuple source(Object key, Object value) {
        Tuple result = null;
        try {
            result = this.operateSource(key, value);
        }
        catch (Exception exception) {
            this.handleException(exception, this.getTupleEntry(new Tuple(key, value)));
        }
        return result;
    }

    private Tuple operateSource(Object key, Object value) {
        try {
            Tuple tuple = this.source.source(key, value);
            this.getFlowProcess().increment(StepCounters.Tuples_Read, 1);
            return tuple;
        }
        catch (OutOfMemoryError error) {
            throw new StackException("out of memory, try increasing task memory allocation", error);
        }
        catch (Throwable throwable) {
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error: " + key.toString() + " " + value.toString(), throwable);
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void cleanup() {
    }
}

