/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.stack.StackElement;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.util.Iterator;
import org.apache.hadoop.mapred.OutputCollector;

abstract class ReducerStackElement
extends StackElement {
    Scope incomingScope;
    private Fields incomingFields;
    private Fields outGroupingFields;
    private TupleEntry groupingTupleEntry;
    private TupleEntry tupleEntry;
    OutputCollector lastOutput;

    ReducerStackElement(StackElement previous, FlowProcess flowProcess, Scope incomingScope, String trapName, Tap trap) {
        super(flowProcess, trapName, trap);
        this.previous = previous;
        this.incomingScope = incomingScope;
    }

    ReducerStackElement(FlowProcess flowProcess, Fields outGroupingFields, String trapName, Tap trap) {
        super(flowProcess, trapName, trap);
        this.outGroupingFields = outGroupingFields;
    }

    protected abstract FlowElement getFlowElement();

    Fields resolveIncomingFields() {
        if (this.incomingFields == null) {
            this.incomingFields = this.getFlowElement().resolveFields(this.incomingScope);
        }
        return this.incomingFields;
    }

    public void setLastOutput(OutputCollector lastOutput) {
        this.lastOutput = lastOutput;
    }

    Scope getIncomingScope() {
        return this.incomingScope;
    }

    Fields resolveIncomingOperationFields() {
        return this.getFlowElement().resolveIncomingOperationFields(this.incomingScope);
    }

    @Override
    public void collect(Tuple key, Iterator values) {
        throw new FlowException("no next stack element");
    }

    @Override
    public void collect(Tuple tuple) {
        throw new FlowException("no next stack element");
    }

    public Fields getOutGroupingFields() {
        if (this.outGroupingFields == null) {
            this.outGroupingFields = this.incomingScope.getOutGroupingFields();
        }
        return this.outGroupingFields;
    }

    TupleEntry getGroupingTupleEntry(Tuple tuple) {
        if (this.groupingTupleEntry == null) {
            this.groupingTupleEntry = new TupleEntry(this.getOutGroupingFields(), true);
        }
        this.groupingTupleEntry.setTuple(tuple);
        return this.groupingTupleEntry;
    }

    TupleEntry getTupleEntry(Tuple tuple) {
        if (this.tupleEntry == null) {
            this.tupleEntry = new TupleEntry(this.resolveIncomingFields(), true);
        }
        this.tupleEntry.setTuple(tuple);
        return this.tupleEntry;
    }
}

