/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.FlowStep;
import cascading.flow.Scope;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.stack.EachReducerStackElement;
import cascading.flow.stack.EveryAggregatorReducerStackElement;
import cascading.flow.stack.EveryAllAggregatorReducerStackElement;
import cascading.flow.stack.EveryBufferReducerStackElement;
import cascading.flow.stack.GroupReducerStackElement;
import cascading.flow.stack.ReducerStackElement;
import cascading.flow.stack.SinkReducerStackElement;
import cascading.flow.stack.StackElement;
import cascading.flow.stack.StackException;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.Pipe;
import cascading.tap.Tap;
import cascading.tap.TempHfs;
import cascading.tuple.Tuple;
import cascading.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.log4j.Logger;

public class FlowReducerStack {
    private static final Logger LOG = Logger.getLogger(FlowReducerStack.class);
    private final FlowStep step;
    private final JobConf jobConf;
    private final HadoopFlowProcess flowProcess;
    private ReducerStackElement stackHead;
    private ReducerStackElement stackTail;

    public FlowReducerStack(HadoopFlowProcess flowProcess) throws IOException {
        this.flowProcess = flowProcess;
        this.jobConf = flowProcess.getJobConf();
        this.step = (FlowStep)Util.deserializeBase64(this.jobConf.getRaw("cascading.flow.step"));
        if (this.jobConf.getNumReduceTasks() == 0) {
            return;
        }
        if (this.step.group == null) {
            throw new IllegalStateException("this step reducer should not be created, num reducers should be zero, found: " + this.jobConf.getNumReduceTasks() + ", in step: " + this.step.getStepName());
        }
        this.buildStack();
        this.stackTail.open();
    }

    private void buildStack() throws IOException {
        Set<Scope> previousScopes = this.step.getPreviousScopes(this.step.group);
        Scope nextScope = this.step.getNextScope(this.step.group);
        String trapName = ((Pipe)this.step.group).getName();
        Tap trap = this.step.getReducerTrap(trapName);
        this.stackTail = new GroupReducerStackElement(this.flowProcess, previousScopes, this.step.group, nextScope, nextScope.getOutGroupingFields(), trap);
        FlowElement operator = this.step.getNextFlowElement(nextScope);
        if (operator instanceof Every && !((Every)operator).isBuffer()) {
            ArrayList<Every.EveryHandler> allAggregators = new ArrayList<Every.EveryHandler>();
            Scope incomingScope = nextScope;
            this.stackTail = new EveryAllAggregatorReducerStackElement((StackElement)this.stackTail, (FlowProcess)this.flowProcess, incomingScope, this.step.reducerTraps, allAggregators);
            while (operator instanceof Every && !((Every)operator).isBuffer()) {
                nextScope = this.step.getNextScope(operator);
                Every.EveryHandler everyHandler = ((Every)operator).getHandler(nextScope);
                allAggregators.add(everyHandler);
                trapName = ((Pipe)operator).getName();
                trap = this.step.getReducerTrap(trapName);
                this.stackTail = new EveryAggregatorReducerStackElement((StackElement)this.stackTail, (FlowProcess)this.flowProcess, incomingScope, trap, everyHandler);
                incomingScope = nextScope;
                operator = this.step.getNextFlowElement(nextScope);
            }
        } else if (operator instanceof Every && ((Every)operator).isBuffer()) {
            Scope incomingScope = nextScope;
            while (operator instanceof Every && ((Every)operator).isBuffer()) {
                nextScope = this.step.getNextScope(operator);
                Every.EveryHandler everyHandler = ((Every)operator).getHandler(nextScope);
                trapName = ((Pipe)operator).getName();
                trap = this.step.getReducerTrap(trapName);
                this.stackTail = new EveryBufferReducerStackElement((StackElement)this.stackTail, (FlowProcess)this.flowProcess, incomingScope, trap, everyHandler);
                incomingScope = nextScope;
                operator = this.step.getNextFlowElement(nextScope);
            }
        }
        while (operator instanceof Each) {
            trapName = ((Pipe)operator).getName();
            trap = this.step.getReducerTrap(trapName);
            this.stackTail = new EachReducerStackElement((StackElement)this.stackTail, (FlowProcess)this.flowProcess, nextScope, trap, (Each)operator);
            nextScope = this.step.getNextScope(operator);
            operator = this.step.getNextFlowElement(nextScope);
        }
        boolean useTapCollector = false;
        useTapCollector = useTapCollector || ((Tap)operator).isWriteDirect();
        this.stackTail = operator instanceof TempHfs ? new SinkReducerStackElement((StackElement)this.stackTail, (FlowProcess)this.flowProcess, nextScope, (Tap)operator, useTapCollector) : new SinkReducerStackElement(this.stackTail, this.flowProcess, nextScope, trapName, trap, (Tap)operator, useTapCollector);
        this.stackHead = (ReducerStackElement)this.stackTail.resolveStack();
    }

    public void reduce(Object key, Iterator values, OutputCollector output) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("reduce fields: " + this.stackHead.getOutGroupingFields()));
            LOG.trace((Object)("reduce key: " + ((Tuple)key).print()));
        }
        this.stackTail.setLastOutput(output);
        try {
            this.stackHead.collect((Tuple)key, values);
        }
        catch (StackException exception) {
            if (exception.getCause() instanceof Error) {
                throw (Error)exception.getCause();
            }
            if (exception.getCause() instanceof IOException) {
                throw (IOException)exception.getCause();
            }
            throw (RuntimeException)exception.getCause();
        }
    }

    public void close() throws IOException {
        this.stackHead.close();
    }
}

