/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.FlowStep;
import cascading.flow.Scope;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.stack.EachMapperStackElement;
import cascading.flow.stack.GroupMapperStackElement;
import cascading.flow.stack.MapperStackElement;
import cascading.flow.stack.SinkMapperStackElement;
import cascading.flow.stack.SourceMapperStackElement;
import cascading.flow.stack.StackException;
import cascading.operation.Function;
import cascading.pipe.Each;
import cascading.pipe.Group;
import cascading.pipe.Pipe;
import cascading.tap.Tap;
import cascading.tap.TempHfs;
import cascading.tuple.Tuple;
import cascading.util.Util;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.log4j.Logger;

public class FlowMapperStack {
    private static final Logger LOG = Logger.getLogger(FlowMapperStack.class);
    private final FlowStep step;
    private final Tap currentSource;
    private final HadoopFlowProcess flowProcess;
    private Stack[] stacks;
    private SourceMapperStackElement sourceElement;

    public FlowMapperStack(HadoopFlowProcess flowProcess) throws IOException {
        this.flowProcess = flowProcess;
        JobConf jobConf = flowProcess.getJobConf();
        this.step = (FlowStep)Util.deserializeBase64(jobConf.getRaw("cascading.flow.step"));
        this.currentSource = (Tap)Util.deserializeBase64(jobConf.getRaw("cascading.step.source"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("map current source: " + this.currentSource));
        }
        this.buildStack();
        for (Stack stack : this.stacks) {
            stack.tail.open();
        }
    }

    private void buildStack() throws IOException {
        Set<Scope> incomingScopes = this.step.getNextScopes(this.currentSource);
        this.sourceElement = this.makeSourceElement(incomingScopes);
        this.stacks = new Stack[incomingScopes.size()];
        int i = 0;
        boolean allFilters = true;
        for (Scope incomingScope : incomingScopes) {
            FlowElement operator = this.step.getNextFlowElement(incomingScope);
            this.stacks[i] = new Stack();
            this.stacks[i].tail = null;
            String trapName = null;
            Tap trap = null;
            while (operator instanceof Each) {
                trapName = ((Pipe)operator).getName();
                trap = this.step.getMapperTrap(trapName);
                this.stacks[i].tail = new EachMapperStackElement(this.stacks[i].tail, (FlowProcess)this.flowProcess, incomingScope, trap, (Each)operator);
                if (((Each)operator).getOperation() instanceof Function) {
                    allFilters = false;
                }
                incomingScope = this.step.getNextScope(operator);
                operator = this.step.getNextFlowElement(incomingScope);
            }
            boolean useTapCollector = false;
            if (operator instanceof Group) {
                Scope outgoingScope = this.step.getNextScope(operator);
                boolean copyTuple = allFilters && i != this.stacks.length - 1;
                trapName = ((Pipe)operator).getName();
                trap = this.step.getMapperTrap(trapName);
                this.stacks[i].tail = new GroupMapperStackElement(this.stacks[i].tail, this.flowProcess, incomingScope, trap, (Group)operator, outgoingScope, copyTuple);
            } else if (operator instanceof Tap) {
                useTapCollector = useTapCollector || ((Tap)operator).isWriteDirect();
                this.stacks[i].tail = new SinkMapperStackElement(this.stacks[i].tail, this.flowProcess, incomingScope, trapName, trap, (Tap)operator, useTapCollector);
            } else {
                throw new IllegalStateException("operator should be group or tap, is instead: " + operator.getClass().getName());
            }
            this.stacks[i].head = (MapperStackElement)this.stacks[i].tail.resolveStack();
            ++i;
        }
    }

    private SourceMapperStackElement makeSourceElement(Set<Scope> incomingScopes) throws IOException {
        Scope scope = incomingScopes.iterator().next();
        FlowElement operator = this.step.getNextFlowElement(scope);
        if (this.currentSource instanceof TempHfs || !(operator instanceof Pipe)) {
            return new SourceMapperStackElement((FlowProcess)this.flowProcess, scope, this.currentSource);
        }
        String trapName = ((Pipe)operator).getName();
        Tap trap = this.step.getMapperTrap(trapName);
        if (incomingScopes.size() != 1) {
            LOG.info((Object)("more than one possible trap for source tap, using trap named: " + trapName));
        }
        return new SourceMapperStackElement(this.flowProcess, scope, trapName, trap, this.currentSource);
    }

    public void map(Object key, Object value, OutputCollector output) throws IOException {
        Tuple tuple = this.sourceElement.source(key, value);
        if (LOG.isDebugEnabled()) {
            if (tuple == null) {
                LOG.debug((Object)"map skipping key and value");
            }
            if (LOG.isTraceEnabled()) {
                if (key instanceof Tuple) {
                    LOG.trace((Object)("map key: " + ((Tuple)key).print()));
                } else {
                    LOG.trace((Object)("map key: [" + key + "]"));
                }
                if (tuple != null) {
                    LOG.trace((Object)("map value: " + tuple.print()));
                }
            }
        }
        if (tuple == null) {
            return;
        }
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i].tail.setLastOutput(output);
            try {
                this.stacks[i].head.collect(tuple);
                continue;
            }
            catch (StackException exception) {
                if (exception.getCause() instanceof Error) {
                    throw (Error)exception.getCause();
                }
                if (exception.getCause() instanceof IOException) {
                    throw (IOException)exception.getCause();
                }
                throw (RuntimeException)exception.getCause();
            }
        }
    }

    public void close() throws IOException {
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i].head.close();
        }
    }

    private class Stack {
        MapperStackElement head;
        MapperStackElement tail;

        private Stack() {
        }
    }
}

