/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.ElementGraph;
import cascading.flow.FlowElement;
import cascading.flow.FlowStep;
import cascading.flow.PlannerException;
import cascading.flow.Scope;
import cascading.pipe.Group;
import cascading.pipe.Pipe;
import cascading.tap.Tap;
import cascading.tap.TempHfs;
import cascading.util.Util;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class StepGraph
extends SimpleDirectedGraph<FlowStep, Integer> {
    private static final Logger LOG = Logger.getLogger(StepGraph.class);

    StepGraph() {
        super(Integer.class);
    }

    StepGraph(String flowName, ElementGraph elementGraph, Map<String, Tap> traps) {
        this();
        this.makeStepGraph(flowName, elementGraph, traps);
        this.verifyTrapsAreUnique(traps);
    }

    private void verifyTrapsAreUnique(Map<String, Tap> traps) {
        for (Tap tap : traps.values()) {
            if (Collections.frequency(traps.values(), tap) == 1) continue;
            throw new PlannerException("traps must be unique, cannot be reused on different branches: " + tap);
        }
    }

    private FlowStep getCreateFlowStep(String flowName, Map<String, FlowStep> steps, String sinkName, int numJobs) {
        if (steps.containsKey(sinkName)) {
            return steps.get(sinkName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating step: " + sinkName));
        }
        FlowStep step = new FlowStep(this.makeStepName(steps, numJobs, sinkName), steps.size() + 1);
        step.setParentFlowName(flowName);
        steps.put(sinkName, step);
        return step;
    }

    private String makeStepName(Map<String, FlowStep> steps, int numJobs, String sinkPath) {
        if (sinkPath.length() > 75) {
            sinkPath = String.format("...%75s", sinkPath.substring(sinkPath.length() - 75));
        }
        return String.format("(%d/%d) %s", steps.size() + 1, numJobs, sinkPath);
    }

    private void makeStepGraph(String flowName, ElementGraph elementGraph, Map<String, Tap> traps) {
        SimpleDirectedGraph<Tap, Integer> tapGraph = elementGraph.makeTapGraph();
        int numJobs = this.countNumJobs(tapGraph);
        LinkedHashMap<String, FlowStep> steps = new LinkedHashMap<String, FlowStep>();
        TopologicalOrderIterator topoIterator = new TopologicalOrderIterator(tapGraph);
        int count = 0;
        while (topoIterator.hasNext()) {
            Tap source = (Tap)topoIterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("handling source: " + source));
            }
            List sinks = Graphs.successorListOf(tapGraph, (Object)source);
            for (Tap sink : sinks) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("handling path: " + source + " -> " + sink));
                }
                FlowStep step = this.getCreateFlowStep(flowName, steps, sink.toString(), numJobs);
                this.addVertex(step);
                if (steps.containsKey(source.toString())) {
                    this.addEdge(steps.get(source.toString()), step, count++);
                }
                List<GraphPath<FlowElement, Scope>> paths = elementGraph.getAllShortestPathsBetween(source, sink);
                for (GraphPath<FlowElement, Scope> path : paths) {
                    if (this.pathContainsTap(path)) continue;
                    List scopes = path.getEdgeList();
                    String sourceName = ((Scope)scopes.get(0)).getName();
                    step.sources.put(source, sourceName);
                    step.sink = sink;
                    if (step.sink.isWriteDirect()) {
                        step.tempSink = new TempHfs("tmp:/" + sink.getPath().toUri().getPath(), true);
                    }
                    FlowElement lhs = source;
                    step.graph.addVertex((Object)lhs);
                    boolean onMapSide = true;
                    for (Scope scope : scopes) {
                        String name;
                        FlowElement rhs = (FlowElement)elementGraph.getEdgeTarget(scope);
                        step.graph.addVertex((Object)rhs);
                        step.graph.addEdge((Object)lhs, (Object)rhs, (Object)scope);
                        if (rhs instanceof Group) {
                            step.group = (Group)rhs;
                            onMapSide = false;
                        } else if (rhs instanceof Pipe && traps.containsKey(name = ((Pipe)rhs).getName())) {
                            if (onMapSide) {
                                step.mapperTraps.put(name, traps.get(name));
                            } else {
                                step.reducerTraps.put(name, traps.get(name));
                            }
                        }
                        lhs = rhs;
                    }
                }
            }
        }
    }

    private int countNumJobs(SimpleDirectedGraph<Tap, Integer> tapGraph) {
        Set vertices = tapGraph.vertexSet();
        int count = 0;
        for (Tap vertice : vertices) {
            if (tapGraph.inDegreeOf((Object)vertice) == 0) continue;
            ++count;
        }
        return count;
    }

    private boolean pathContainsTap(GraphPath<FlowElement, Scope> path) {
        List flowElements = Graphs.getPathVertexList(path);
        int count = 0;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof Tap)) continue;
            ++count;
        }
        return count > 2;
    }

    public TopologicalOrderIterator<FlowStep, Integer> getTopologicalIterator() {
        return new TopologicalOrderIterator((DirectedGraph)this);
    }

    public void writeDOT(String filename) {
        this.printElementGraph(filename);
    }

    protected void printElementGraph(String filename) {
        try {
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, this, new IntegerNameProvider(), (VertexNameProvider)new VertexNameProvider<FlowStep>(){

                public String getVertexName(FlowStep object) {
                    String sourceName = "";
                    for (Tap source : object.sources.keySet()) {
                        if (source instanceof TempHfs) continue;
                        sourceName = sourceName + "[" + source.getPath() + "]";
                    }
                    String sinkName = object.sink instanceof TempHfs ? "" : "[" + object.sink.getPath() + "]";
                    String groupName = object.group == null ? "" : object.group.getName();
                    String name = "[" + object.getName() + "]";
                    if (sourceName.length() != 0) {
                        name = name + "\\nsrc:" + sourceName;
                    }
                    if (groupName.length() != 0) {
                        name = name + "\\ngrp:" + groupName;
                    }
                    if (sinkName.length() != 0) {
                        name = name + "\\nsnk:" + sinkName;
                    }
                    return name.replaceAll("\"", "'");
                }
            }, null);
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

