/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;

public class Scope
implements Serializable {
    private String name;
    private Kind kind;
    private Fields remainderFields;
    private Fields argumentFields;
    private Fields declaredFields;
    private boolean isGroupBy;
    private Map<String, Fields> groupingSelectors;
    private Map<String, Fields> sortingSelectors;
    private Fields outGroupingSelector;
    private Fields outGroupingFields;
    private Fields outValuesSelector;
    private Fields outValuesFields;
    private transient TupleEntry argumentsEntry;
    private transient TupleEntry declaredEntry;

    public Scope() {
    }

    public Scope(Scope scope) {
        this.name = scope.getName();
        this.copyFields(scope);
    }

    public Scope(Fields outFields) {
        this.kind = Kind.TAP;
        if (outFields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        this.outGroupingFields = outFields;
        this.outValuesFields = outFields;
    }

    public Scope(String name, Kind kind, Fields remainderFields, Fields argumentFields, Fields declaredFields, Fields outGroupingFields, Fields outValuesFields) {
        this.name = name;
        this.kind = kind;
        this.remainderFields = remainderFields;
        this.argumentFields = argumentFields;
        this.declaredFields = declaredFields;
        if (outGroupingFields == null) {
            throw new IllegalArgumentException("grouping may not be null");
        }
        if (outValuesFields == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (kind == Kind.EACH) {
            this.outGroupingFields = Fields.asDeclaration(outGroupingFields);
            this.outValuesSelector = outValuesFields;
            this.outValuesFields = Fields.asDeclaration(outValuesFields);
        } else if (kind == Kind.EVERY) {
            this.outGroupingSelector = outGroupingFields;
            this.outGroupingFields = Fields.asDeclaration(outGroupingFields);
            this.outValuesFields = outValuesFields;
        } else {
            throw new IllegalArgumentException("may not use the constructor for kind: " + (Object)((Object)kind));
        }
    }

    public Scope(String name, Fields declaredFields, Fields outGroupingFields, Map<String, Fields> groupingSelectors, Map<String, Fields> sortingSelectors, Fields outValuesFields, boolean isGroupBy) {
        this.name = name;
        this.kind = Kind.GROUP;
        this.isGroupBy = isGroupBy;
        if (groupingSelectors == null) {
            throw new IllegalArgumentException("grouping may not be null");
        }
        if (outValuesFields == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        this.declaredFields = declaredFields;
        this.outGroupingFields = outGroupingFields;
        this.groupingSelectors = groupingSelectors;
        this.sortingSelectors = sortingSelectors;
        this.outValuesFields = outValuesFields;
    }

    public Scope(String name) {
        this.name = name;
    }

    public boolean isGroup() {
        return this.kind == Kind.GROUP;
    }

    public boolean isEach() {
        return this.kind == Kind.EACH;
    }

    public boolean isEvery() {
        return this.kind == Kind.EVERY;
    }

    public boolean isTap() {
        return this.kind == Kind.TAP;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Fields getRemainderFields() {
        return this.remainderFields;
    }

    public Fields getArgumentFields() {
        return this.argumentFields;
    }

    public Fields getArguments() {
        return Fields.asDeclaration(this.argumentFields);
    }

    public TupleEntry getArgumentsEntry() {
        if (this.argumentsEntry != null) {
            return this.argumentsEntry;
        }
        this.argumentsEntry = new TupleEntry(this.getArguments(), true);
        return this.argumentsEntry;
    }

    public TupleEntry getArgumentsEntry(TupleEntry input) {
        TupleEntry entry = this.getArgumentsEntry();
        entry.setTuple(input.selectTuple(this.getArgumentFields()));
        return entry;
    }

    public Fields getDeclaredFields() {
        return this.declaredFields;
    }

    public TupleEntry getDeclaredEntry() {
        if (this.declaredEntry != null) {
            return this.declaredEntry;
        }
        this.declaredEntry = new TupleEntry(this.getDeclaredFields());
        return this.declaredEntry;
    }

    public Map<String, Fields> getGroupingSelectors() {
        return this.groupingSelectors;
    }

    public Map<String, Fields> getSortingSelectors() {
        return this.sortingSelectors;
    }

    public Fields getOutGroupingSelector() {
        return this.outGroupingSelector;
    }

    public Fields getOutGroupingFields() {
        if (this.kind != Kind.GROUP) {
            return this.outGroupingFields;
        }
        Fields first = this.groupingSelectors.values().iterator().next();
        if (this.groupingSelectors.size() == 1 || this.isGroup() && this.isGroupBy) {
            return first;
        }
        if (this.outGroupingFields != null) {
            return this.outGroupingFields;
        }
        HashSet<Fields> set = new HashSet<Fields>(this.groupingSelectors.values());
        if (set.size() == 1) {
            return first;
        }
        return Fields.size(first.size());
    }

    public Fields getOutValuesSelector() {
        return this.outValuesSelector;
    }

    public Fields getOutValuesFields() {
        return this.outValuesFields;
    }

    public void copyFields(Scope scope) {
        this.kind = scope.kind;
        this.isGroupBy = scope.isGroupBy;
        this.remainderFields = scope.remainderFields;
        this.argumentFields = scope.argumentFields;
        this.declaredFields = scope.declaredFields;
        this.groupingSelectors = scope.groupingSelectors;
        this.sortingSelectors = scope.sortingSelectors;
        this.outGroupingSelector = scope.outGroupingSelector;
        this.outGroupingFields = scope.outGroupingFields;
        this.outValuesSelector = scope.outValuesSelector;
        this.outValuesFields = scope.outValuesFields;
    }

    public String toString() {
        if (this.getOutValuesFields() == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.groupingSelectors != null && !this.groupingSelectors.isEmpty()) {
            for (String name : this.groupingSelectors.keySet()) {
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append(name).append(this.groupingSelectors.get(name).printVerbose());
            }
            buffer.append("\n");
        }
        if (this.outGroupingFields != null) {
            buffer.append(this.getOutGroupingFields().printVerbose()).append("\n");
        }
        buffer.append(this.getOutValuesFields().printVerbose());
        return buffer.toString();
    }

    public static enum Kind {
        TAP,
        EACH,
        EVERY,
        GROUP;

    }
}

