/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.CascadingException;
import cascading.flow.FlowException;
import cascading.flow.FlowSession;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopUtil;
import cascading.flow.stack.FlowMapperStack;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class FlowMapper
extends MapReduceBase
implements Mapper {
    private FlowMapperStack flowMapperStack;
    private HadoopFlowProcess currentProcess;

    public void configure(JobConf jobConf) {
        try {
            super.configure(jobConf);
            HadoopUtil.initLog4j(jobConf);
            this.currentProcess = new HadoopFlowProcess(new FlowSession(), jobConf, true);
            this.flowMapperStack = new FlowMapperStack(this.currentProcess);
        }
        catch (Throwable throwable) {
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error during mapper configuration", throwable);
        }
    }

    public void map(Object key, Object value, OutputCollector output, Reporter reporter) throws IOException {
        this.currentProcess.setReporter(reporter);
        try {
            this.flowMapperStack.map(key, value, output);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error during mapper execution", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.flowMapperStack.close();
        }
    }
}

