/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.CascadingException;
import cascading.cascade.Cascade;
import cascading.flow.ElementGraph;
import cascading.flow.FlowException;
import cascading.flow.FlowListener;
import cascading.flow.FlowSkipIfSinkStale;
import cascading.flow.FlowSkipStrategy;
import cascading.flow.FlowStep;
import cascading.flow.FlowStepJob;
import cascading.flow.StepGraph;
import cascading.stats.FlowStats;
import cascading.tap.Tap;
import cascading.tap.hadoop.HttpFileSystem;
import cascading.tap.hadoop.S3HttpFileSystem;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class Flow
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Flow.class);
    private static Thread hdfsShutdown = null;
    private static int shutdownCount = 0;
    private String id;
    private String name;
    private List<SafeFlowListener> listeners;
    private FlowSkipStrategy flowSkipStrategy = new FlowSkipIfSinkStale();
    private final FlowStats flowStats;
    private Map<String, Tap> sources;
    private Map<String, Tap> sinks;
    private Map<String, Tap> traps;
    private boolean preserveTemporaryFiles = false;
    protected boolean stopJobsOnExit = true;
    private StepGraph stepGraph;
    private JobConf jobConf;
    private Thread thread;
    private Throwable throwable;
    private boolean stop;
    private ElementGraph pipeGraph;
    private transient List<FlowStep> steps;
    private transient Map<String, Callable<Throwable>> jobsMap;
    private transient ExecutorService executor;
    private transient Thread shutdownHook;

    public static void setPreserveTemporaryFiles(Map<Object, Object> properties, boolean preserveTemporaryFiles) {
        properties.put("cascading.flow.preservetemporaryfiles", Boolean.toString(preserveTemporaryFiles));
    }

    public static boolean getPreserveTemporaryFiles(Map<Object, Object> properties) {
        return Boolean.parseBoolean(Util.getProperty(properties, "cascading.flow.preservetemporaryfiles", "false"));
    }

    public static void setStopJobsOnExit(Map<Object, Object> properties, boolean stopJobsOnExit) {
        properties.put("cascading.flow.stopjobsonexit", Boolean.toString(stopJobsOnExit));
    }

    public static boolean getStopJobsOnExit(Map<Object, Object> properties) {
        return Boolean.parseBoolean(Util.getProperty(properties, "cascading.flow.stopjobsonexit", "true"));
    }

    public static void setJobPollingInterval(Map<Object, Object> properties, long interval) {
        properties.put("cascading.flow.job.pollinginterval", Long.toString(interval));
    }

    public static long getJobPollingInterval(Map<Object, Object> properties) {
        return Long.parseLong(Util.getProperty(properties, "cascading.flow.job.pollinginterval", "500"));
    }

    public static long getJobPollingInterval(JobConf jobConf) {
        return jobConf.getLong("cascading.flow.job.pollinginterval", 5000L);
    }

    protected Flow() {
        this.name = "NA";
        this.flowStats = new FlowStats(this.getID());
    }

    protected Flow(Map<Object, Object> properties, JobConf jobConf, String name, ElementGraph pipeGraph, StepGraph stepGraph, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps) {
        this.name = name;
        this.pipeGraph = pipeGraph;
        this.stepGraph = stepGraph;
        this.flowStats = new FlowStats(this.getID());
        this.setJobConf(jobConf);
        this.setSources(sources);
        this.setSinks(sinks);
        this.setTraps(traps);
        this.initFromProperties(properties);
        this.initFromTaps();
    }

    protected Flow(Map<Object, Object> properties, JobConf jobConf, String name, StepGraph stepGraph, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps) {
        this.name = name;
        this.stepGraph = stepGraph;
        this.flowStats = new FlowStats(this.getID());
        this.setJobConf(jobConf);
        this.setSources(sources);
        this.setSinks(sinks);
        this.setTraps(traps);
        this.initFromProperties(properties);
        this.initFromTaps();
    }

    private void initFromProperties(Map<Object, Object> properties) {
        this.preserveTemporaryFiles = Flow.getPreserveTemporaryFiles(properties);
        this.stopJobsOnExit = Flow.getStopJobsOnExit(properties);
    }

    private void initFromTaps() {
        this.initFromTaps(this.sources);
        this.initFromTaps(this.sinks);
        this.initFromTaps(this.traps);
    }

    private void initFromTaps(Map<String, Tap> taps) {
        for (Tap tap : taps.values()) {
            tap.flowInit(this);
        }
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getID() {
        if (this.id == null) {
            this.id = Util.createUniqueID(this.getName());
        }
        return this.id;
    }

    protected void setSources(Map<String, Tap> sources) {
        this.addListeners(sources.values());
        this.sources = sources;
    }

    protected void setSinks(Map<String, Tap> sinks) {
        this.addListeners(sinks.values());
        this.sinks = sinks;
    }

    protected void setTraps(Map<String, Tap> traps) {
        this.addListeners(traps.values());
        this.traps = traps;
    }

    protected void setStepGraph(StepGraph stepGraph) {
        this.stepGraph = stepGraph;
    }

    private void setJobConf(JobConf jobConf) {
        if (jobConf == null) {
            return;
        }
        this.jobConf = new JobConf((Configuration)jobConf);
        this.jobConf.set("fs.http.impl", HttpFileSystem.class.getName());
        this.jobConf.set("fs.https.impl", HttpFileSystem.class.getName());
        this.jobConf.set("fs.s3tp.impl", S3HttpFileSystem.class.getName());
        this.jobConf.set("cascading.flow.id", this.getID());
    }

    public JobConf getJobConf() {
        if (this.jobConf == null) {
            this.setJobConf(new JobConf());
        }
        return this.jobConf;
    }

    public void setProperty(String key, String value) {
        this.getJobConf().set(key, value);
    }

    public String getProperty(String key) {
        return this.getJobConf().get(key);
    }

    public FlowStats getFlowStats() {
        return this.flowStats;
    }

    void addListeners(Collection listeners) {
        for (Object listener : listeners) {
            if (!(listener instanceof FlowListener)) continue;
            this.addListener((FlowListener)listener);
        }
    }

    List<SafeFlowListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<SafeFlowListener>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void addListener(FlowListener flowListener) {
        this.getListeners().add(new SafeFlowListener(flowListener));
    }

    public boolean removeListener(FlowListener flowListener) {
        return this.getListeners().remove(new SafeFlowListener(flowListener));
    }

    public Map<String, Tap> getSources() {
        return Collections.unmodifiableMap(this.sources);
    }

    public Map<String, Tap> getSinks() {
        return Collections.unmodifiableMap(this.sinks);
    }

    public Map<String, Tap> getTraps() {
        return Collections.unmodifiableMap(this.traps);
    }

    public Tap getSink() {
        return this.sinks.values().iterator().next();
    }

    public boolean isPreserveTemporaryFiles() {
        return this.preserveTemporaryFiles;
    }

    public boolean isStopJobsOnExit() {
        return this.stopJobsOnExit;
    }

    public FlowSkipStrategy getFlowSkipStrategy() {
        return this.flowSkipStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowSkipStrategy setFlowSkipStrategy(FlowSkipStrategy flowSkipStrategy) {
        if (flowSkipStrategy == null) {
            throw new IllegalArgumentException("flowSkipStrategy may not be null");
        }
        try {
            FlowSkipStrategy flowSkipStrategy2 = this.flowSkipStrategy;
            return flowSkipStrategy2;
        }
        finally {
            this.flowSkipStrategy = flowSkipStrategy;
        }
    }

    public boolean isSkipFlow() throws IOException {
        return this.flowSkipStrategy.skipFlow(this);
    }

    public boolean areSinksStale() throws IOException {
        return this.areSourcesNewer(this.getSinkModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areSourcesNewer(long sinkModified) throws IOException {
        JobConf confCopy = new JobConf((Configuration)this.getJobConf());
        long sourceMod = 0L;
        try {
            for (Tap source : this.sources.values()) {
                if (!source.pathExists(confCopy)) {
                    throw new FlowException("source does not exist: " + source);
                }
                sourceMod = source.getPathModified(confCopy);
                if (sinkModified >= sourceMod) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (LOG.isInfoEnabled()) {
                this.logInfo("source modification date at: " + new Date(sourceMod));
            }
        }
    }

    public long getSinkModified() throws IOException {
        JobConf confCopy = new JobConf((Configuration)this.getJobConf());
        long sinkModified = Long.MAX_VALUE;
        for (Tap sink : this.sinks.values()) {
            if (sink.isReplace() || sink.isUpdate()) {
                sinkModified = -1L;
                continue;
            }
            if (!sink.pathExists(confCopy)) {
                sinkModified = 0L;
                continue;
            }
            sinkModified = Math.min(sinkModified, sink.getPathModified(confCopy));
        }
        if (LOG.isInfoEnabled()) {
            if (sinkModified == -1L) {
                this.logInfo("atleast one sink is marked for delete");
            }
            if (sinkModified == 0L) {
                this.logInfo("atleast one sink does not exist");
            } else {
                this.logInfo("sink oldest modified date: " + new Date(sinkModified));
            }
        }
        return sinkModified;
    }

    public List<FlowStep> getSteps() {
        if (this.steps != null) {
            return this.steps;
        }
        TopologicalOrderIterator topoIterator = new TopologicalOrderIterator((DirectedGraph)this.stepGraph);
        this.steps = new ArrayList<FlowStep>();
        while (topoIterator.hasNext()) {
            this.steps.add((FlowStep)topoIterator.next());
        }
        return this.steps;
    }

    public synchronized void start() {
        if (this.thread != null) {
            return;
        }
        if (this.stop) {
            return;
        }
        this.registerShutdownHook();
        this.thread = new Thread((Runnable)this, ("flow " + Util.toNull(this.getName())).trim());
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.stop) {
            return;
        }
        if (this.thread == null) {
            return;
        }
        this.stop = true;
        this.fireOnStopping();
        if (!this.flowStats.isFinished()) {
            this.flowStats.markStopped();
        }
        this.internalStopAllJobs();
        this.handleExecutorShutdown();
        if (!this.isPreserveTemporaryFiles()) {
            this.cleanTemporaryFiles(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        block12: {
            this.start();
            try {
                try {
                    this.thread.join();
                }
                catch (InterruptedException exception) {
                    throw new FlowException(this.getName(), "thread interrupted", exception);
                }
                if (this.throwable instanceof FlowException) {
                    ((FlowException)this.throwable).setFlowName(this.getName());
                }
                if (this.throwable instanceof CascadingException) {
                    throw (CascadingException)this.throwable;
                }
                if (this.throwable != null) {
                    throw new FlowException(this.getName(), "unhandled exception", this.throwable);
                }
                if (this.hasListeners()) {
                    for (SafeFlowListener safeFlowListener : this.getListeners()) {
                        if (safeFlowListener.throwable == null) continue;
                        throw new FlowException(this.getName(), "unhandled listener exception", this.throwable);
                    }
                }
                this.thread = null;
                this.throwable = null;
                if (!this.hasListeners()) break block12;
            }
            catch (Throwable throwable) {
                this.thread = null;
                this.throwable = null;
                if (this.hasListeners()) {
                    for (SafeFlowListener safeFlowListener : this.getListeners()) {
                        safeFlowListener.throwable = null;
                    }
                }
                throw throwable;
            }
            for (SafeFlowListener safeFlowListener : this.getListeners()) {
                safeFlowListener.throwable = null;
            }
        }
    }

    public TupleEntryIterator openSource() throws IOException {
        return this.sources.values().iterator().next().openForRead(this.getJobConf());
    }

    public TupleEntryIterator openSource(String name) throws IOException {
        return this.sources.get(name).openForRead(this.getJobConf());
    }

    public TupleEntryIterator openSink() throws IOException {
        return this.sinks.values().iterator().next().openForRead(this.getJobConf());
    }

    public TupleEntryIterator openSink(String name) throws IOException {
        return this.sinks.get(name).openForRead(this.getJobConf());
    }

    public TupleEntryIterator openTrap() throws IOException {
        return this.traps.values().iterator().next().openForRead(this.getJobConf());
    }

    public TupleEntryIterator openTrap(String name) throws IOException {
        return this.traps.get(name).openForRead(this.getJobConf());
    }

    public void deleteSinks() throws IOException {
        for (Tap tap : this.sinks.values()) {
            tap.deletePath(this.getJobConf());
        }
    }

    public void deleteSinksIfNotAppend() throws IOException {
        for (Tap tap : this.sinks.values()) {
            if (tap.isUpdate()) continue;
            tap.deletePath(this.getJobConf());
        }
    }

    public void deleteSinksIfNotUpdate() throws IOException {
        for (Tap tap : this.sinks.values()) {
            if (tap.isUpdate()) continue;
            tap.deletePath(this.getJobConf());
        }
    }

    public boolean tapPathExists(Tap tap) throws IOException {
        return tap.pathExists(this.getJobConf());
    }

    public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
        return tap.openForRead(this.getJobConf());
    }

    public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
        return tap.openForWrite(this.getJobConf());
    }

    public boolean jobsAreLocal() {
        return this.getJobConf().get("mapred.job.tracker").equalsIgnoreCase("local");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.thread == null) {
            throw new IllegalStateException("to start a Flow call start() or complete(), not Runnable#run()");
        }
        Cascade.printBanner();
        try {
            int numThreads;
            this.flowStats.markRunning();
            this.fireOnStarting();
            if (LOG.isInfoEnabled()) {
                this.logInfo("starting");
                for (Tap source : this.getSources().values()) {
                    this.logInfo(" source: " + source);
                }
                for (Tap sink : this.getSinks().values()) {
                    this.logInfo(" sink: " + sink);
                }
            }
            this.initializeNewJobsMap();
            int n = numThreads = this.jobsAreLocal() ? 1 : this.jobsMap.size();
            if (numThreads == 0) {
                throw new IllegalStateException("no jobs rendered for flow: " + this.getName());
            }
            if (LOG.isInfoEnabled()) {
                this.logInfo(" parallel execution is enabled: " + !this.jobsAreLocal());
                this.logInfo(" starting jobs: " + this.jobsMap.size());
                this.logInfo(" allocating threads: " + numThreads);
            }
            List<Future<Throwable>> futures = this.spawnJobs(numThreads);
            for (Future<Throwable> future : futures) {
                this.throwable = future.get();
                if (this.throwable == null) continue;
                if (!this.stop) {
                    this.internalStopAllJobs();
                }
                this.handleExecutorShutdown();
                break;
            }
        }
        catch (Throwable throwable) {
            this.throwable = throwable;
        }
        finally {
            if (!this.isPreserveTemporaryFiles()) {
                this.cleanTemporaryFiles(this.stop);
            }
            this.handleThrowableAndMarkFailed();
            if (!this.stop && !this.flowStats.isFinished()) {
                this.flowStats.markSuccessful();
            }
            try {
                this.fireOnCompleted();
            }
            finally {
                this.deregisterShutdownHook();
            }
        }
    }

    private List<Future<Throwable>> spawnJobs(int numThreads) throws InterruptedException {
        if (this.stop) {
            return new ArrayList<Future<Throwable>>();
        }
        this.executor = Executors.newFixedThreadPool(numThreads);
        List<Future<Throwable>> futures = this.executor.invokeAll(this.jobsMap.values());
        this.executor.shutdown();
        return futures;
    }

    private void handleThrowableAndMarkFailed() {
        if (this.throwable != null && !this.stop) {
            this.flowStats.markFailed(this.throwable);
            this.fireOnThrowable();
        }
    }

    synchronized Map<String, Callable<Throwable>> getJobsMap() {
        return this.jobsMap;
    }

    private synchronized void initializeNewJobsMap() throws IOException {
        this.jobsMap = new LinkedHashMap<String, Callable<Throwable>>();
        TopologicalOrderIterator<FlowStep, Integer> topoIterator = this.stepGraph.getTopologicalIterator();
        while (topoIterator.hasNext()) {
            FlowStep step = (FlowStep)topoIterator.next();
            FlowStepJob flowStepJob = step.createFlowStepJob(this.getJobConf());
            this.jobsMap.put(step.getName(), flowStepJob);
            ArrayList<FlowStepJob> predecessors = new ArrayList<FlowStepJob>();
            for (FlowStep flowStep : Graphs.predecessorListOf((DirectedGraph)this.stepGraph, (Object)step)) {
                predecessors.add((FlowStepJob)this.jobsMap.get(flowStep.getName()));
            }
            flowStepJob.setPredecessors(predecessors);
            this.flowStats.addStepStats(flowStepJob.getStepStats());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStopAllJobs() {
        LOG.warn((Object)"stopping jobs");
        try {
            if (this.jobsMap == null) {
                return;
            }
            ArrayList<Callable<Throwable>> jobs = new ArrayList<Callable<Throwable>>(this.jobsMap.values());
            Collections.reverse(jobs);
            for (Callable callable : jobs) {
                ((FlowStepJob)callable).stop();
            }
        }
        finally {
            LOG.warn((Object)"stopped jobs");
        }
    }

    private void handleExecutorShutdown() {
        if (this.executor == null) {
            return;
        }
        LOG.warn((Object)"shutting down job executor");
        try {
            this.executor.awaitTermination(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.warn((Object)"shutdown complete");
    }

    private void fireOnCompleted() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onCompleted event: " + this.getListeners().size());
            }
            for (SafeFlowListener flowListener : this.getListeners()) {
                flowListener.onCompleted(this);
            }
        }
    }

    private void fireOnThrowable() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onThrowable event: " + this.getListeners().size());
            }
            boolean isHandled = false;
            for (SafeFlowListener flowListener : this.getListeners()) {
                isHandled = flowListener.onThrowable(this, this.throwable) || isHandled;
            }
            if (isHandled) {
                this.throwable = null;
            }
        }
    }

    private void fireOnStopping() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStopping event: " + this.getListeners().size());
            }
            for (SafeFlowListener flowListener : this.getListeners()) {
                flowListener.onStopping(this);
            }
        }
    }

    private void fireOnStarting() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStarting event: " + this.getListeners().size());
            }
            for (SafeFlowListener flowListener : this.getListeners()) {
                flowListener.onStarting(this);
            }
        }
    }

    private void cleanTemporaryFiles(boolean stop) {
        if (stop) {
            return;
        }
        for (FlowStep step : this.getSteps()) {
            step.clean(this.getJobConf());
        }
    }

    private void registerShutdownHook() {
        if (!this.isStopJobsOnExit()) {
            return;
        }
        Flow.getHdfsShutdownHook();
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                Flow.this.stop();
                Flow.callHdfsShutdownHook();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private static synchronized void callHdfsShutdownHook() {
        if (--shutdownCount != 0) {
            return;
        }
        if (hdfsShutdown != null) {
            hdfsShutdown.start();
        }
    }

    private static synchronized void getHdfsShutdownHook() {
        ++shutdownCount;
        if (hdfsShutdown == null) {
            hdfsShutdown = Util.getHDFSShutdownHook();
        }
    }

    private void deregisterShutdownHook() {
        if (!this.isStopJobsOnExit() || this.stop) {
            return;
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getName() != null) {
            buffer.append(this.getName()).append(": ");
        }
        for (FlowStep step : this.getSteps()) {
            buffer.append(step);
        }
        return buffer.toString();
    }

    private void logInfo(String message) {
        LOG.info((Object)("[" + Util.truncate(this.getName(), 25) + "] " + message));
    }

    private void logDebug(String message) {
        LOG.debug((Object)("[" + Util.truncate(this.getName(), 25) + "] " + message));
    }

    private void logWarn(String message, Throwable throwable) {
        LOG.warn((Object)("[" + Util.truncate(this.getName(), 25) + "] " + message), throwable);
    }

    public void writeDOT(String filename) {
        if (this.pipeGraph == null) {
            throw new UnsupportedOperationException("this flow instance cannot write a DOT file");
        }
        this.pipeGraph.writeDOT(filename);
    }

    public void writeStepsDOT(String filename) {
        if (this.stepGraph == null) {
            throw new UnsupportedOperationException("this flow instance cannot write a DOT file");
        }
        this.stepGraph.writeDOT(filename);
    }

    public FlowHolder getHolder() {
        return new FlowHolder(this);
    }

    private class SafeFlowListener
    implements FlowListener {
        final FlowListener flowListener;
        Throwable throwable;

        private SafeFlowListener(FlowListener flowListener) {
            this.flowListener = flowListener;
        }

        @Override
        public void onStarting(Flow flow) {
            try {
                this.flowListener.onStarting(flow);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
        }

        @Override
        public void onStopping(Flow flow) {
            try {
                this.flowListener.onStopping(flow);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
        }

        @Override
        public void onCompleted(Flow flow) {
            try {
                this.flowListener.onCompleted(flow);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
        }

        @Override
        public boolean onThrowable(Flow flow, Throwable flowThrowable) {
            try {
                return this.flowListener.onThrowable(flow, flowThrowable);
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
                return false;
            }
        }

        private void handleThrowable(Throwable throwable) {
            this.throwable = throwable;
            Flow.this.logWarn(String.format("flow listener %s threw throwable", this.flowListener), throwable);
            Flow.this.stop();
        }

        public boolean equals(Object object) {
            if (object instanceof SafeFlowListener) {
                return this.flowListener.equals(((SafeFlowListener)object).flowListener);
            }
            return this.flowListener.equals(object);
        }

        public int hashCode() {
            return this.flowListener.hashCode();
        }
    }

    public static class FlowHolder {
        public Flow flow;

        public FlowHolder() {
        }

        public FlowHolder(Flow flow) {
            this.flow = flow;
        }
    }
}

