/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.tuple.TupleInputStream;
import cascading.tuple.hadoop.TupleSerialization;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.log4j.Logger;

public class SerializationElementReader
implements TupleInputStream.ElementReader {
    private static final Logger LOG = Logger.getLogger(SerializationElementReader.class);
    private final TupleSerialization tupleSerialization;
    Map<String, Deserializer> deserializers = new HashMap<String, Deserializer>();

    public SerializationElementReader(TupleSerialization tupleSerialization) {
        this.tupleSerialization = tupleSerialization;
        tupleSerialization.initTokenMaps();
    }

    @Override
    public Object read(int token, DataInputStream inputStream) throws IOException {
        Deserializer deserializer;
        String className = this.tupleSerialization.getClassNameFor(token);
        if (className == null) {
            className = WritableUtils.readString((DataInput)inputStream);
        }
        if ((deserializer = this.deserializers.get(className)) == null) {
            deserializer = this.tupleSerialization.getNewDeserializer(className);
            deserializer.open((InputStream)inputStream);
            this.deserializers.put(className, deserializer);
        }
        Object foundObject = null;
        Object object = null;
        try {
            object = deserializer.deserialize(foundObject);
        }
        catch (IOException exception) {
            LOG.error((Object)("failed deserializing token: " + token + " with classname: " + className), (Throwable)exception);
            throw exception;
        }
        return object;
    }

    @Override
    public void close() {
        if (this.deserializers.size() == 0) {
            return;
        }
        ArrayList<Deserializer> clone = new ArrayList<Deserializer>(this.deserializers.values());
        this.deserializers.clear();
        for (Deserializer deserializer : clone) {
            try {
                deserializer.close();
            }
            catch (IOException exception) {}
        }
    }
}

