/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.FieldsResolverException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Fields
implements Comparable,
Iterable<Comparable>,
Serializable,
Comparator<Tuple> {
    public static final Fields UNKNOWN = new Fields(Kind.UNKNOWN);
    public static final Fields ALL = new Fields(Kind.ALL);
    public static final Fields GROUP = new Fields(Kind.GROUP);
    public static final Fields VALUES = new Fields(Kind.VALUES);
    public static final Fields ARGS = new Fields(Kind.ARGS);
    public static final Fields RESULTS = new Fields(Kind.RESULTS);
    public static final Fields REPLACE = new Fields(Kind.REPLACE);
    public static final Fields SWAP = new Fields(Kind.SWAP);
    public static final Fields FIRST = new Fields(Integer.valueOf(0));
    public static final Fields LAST = new Fields(Integer.valueOf(-1));
    private static final int[] EMPTY_INT = new int[0];
    Comparable[] fields = new Comparable[0];
    boolean isOrdered = true;
    Kind kind;
    Comparator[] comparators;
    transient int[] thisPos;
    transient Map<Comparable, Integer> index;
    transient Map<Fields, int[]> posCache;
    transient int hashCode;

    public static Fields[] fields(Fields ... fields) {
        return fields;
    }

    public static Fields size(int size) {
        Fields fields = new Fields();
        fields.fields = Fields.expand(size, 0);
        return fields;
    }

    public static Fields join(Fields ... fields) {
        int size = 0;
        for (Fields field : fields) {
            if (field.isSubstitution() || field.isUnknown()) {
                throw new TupleException("cannot join fields if one is a substitution or is unknown");
            }
            size += field.size();
        }
        Comparable[] elements = Fields.join(size, fields);
        return new Fields(elements);
    }

    private static Comparable[] join(int size, Fields ... fields) {
        Comparable[] elements = Fields.expand(size, 0);
        int pos = 0;
        for (Fields field : fields) {
            System.arraycopy(field.fields, 0, elements, pos, field.size());
            pos += field.size();
        }
        return elements;
    }

    public static Fields offsetSelector(int size, int startPos) {
        Fields fields = new Fields();
        fields.isOrdered = false;
        fields.fields = Fields.expand(size, startPos);
        return fields;
    }

    private static Comparable[] expand(int size, int startPos) {
        if (size < 1) {
            throw new TupleException("invalid size for fields: " + size);
        }
        if (startPos < 0) {
            throw new TupleException("invalid start position for fields: " + startPos);
        }
        Comparable[] fields = new Comparable[size];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = Integer.valueOf(i + startPos);
        }
        return fields;
    }

    public static Fields resolve(Fields selector, Fields ... fields) {
        boolean hasUnknowns = false;
        int size = 0;
        for (Fields field : fields) {
            if (field.isUnknown()) {
                hasUnknowns = true;
            }
            if (!field.isDefined() && field.isUnOrdered()) {
                throw new TupleException("unable to select from field set: " + field.printVerbose());
            }
            size += field.size();
        }
        if (selector.isAll()) {
            Fields result = fields[0];
            for (int i = 1; i < fields.length; ++i) {
                result = result.append(fields[i]);
            }
            return result;
        }
        if (selector.isReplace()) {
            if (fields[1].isUnknown()) {
                throw new TupleException("cannot replace fields with unknown field declaration");
            }
            if (!fields[0].contains(fields[1])) {
                throw new TupleException("could not find all fields to be replaced, available: " + fields[0].printVerbose() + ",  declared: " + fields[1].printVerbose());
            }
            return fields[0];
        }
        if (!selector.isDefined()) {
            throw new TupleException("unable to use given selector: " + selector);
        }
        LinkedHashSet<String> notFound = new LinkedHashSet<String>();
        HashSet<String> found = new HashSet<String>();
        Fields result = Fields.size(selector.size());
        if (hasUnknowns) {
            size = -1;
        }
        int offset = 0;
        for (Fields current : fields) {
            Fields.resolveInto(notFound, found, selector, current, result, offset, size);
            offset += current.size();
        }
        notFound.removeAll(found);
        if (!notFound.isEmpty()) {
            throw new FieldsResolverException(new Fields(Fields.join(size, fields)), new Fields(notFound.toArray(new Comparable[0])));
        }
        if (hasUnknowns) {
            return selector;
        }
        return result;
    }

    private static void resolveInto(Set<String> notFound, Set<String> found, Fields selector, Fields current, Fields result, int offset, int size) {
        for (int i = 0; i < selector.size(); ++i) {
            Comparable field = selector.get(i);
            if (field instanceof String) {
                int index = current.indexOfSafe(field);
                if (index == -1) {
                    notFound.add((String)((Object)field));
                    continue;
                }
                result.set(i, Fields.handleFound(found, field));
                continue;
            }
            int pos = current.translatePos((Integer)field, size) - offset;
            if (pos >= current.size() || pos < 0) continue;
            Comparable thisField = current.get(pos);
            if (thisField instanceof String) {
                result.set(i, Fields.handleFound(found, thisField));
                continue;
            }
            result.set(i, field);
        }
    }

    private static Comparable handleFound(Set<String> found, Comparable field) {
        if (found.contains((String)((Object)field))) {
            throw new TupleException("field name already exists: " + field);
        }
        found.add((String)((Object)field));
        return field;
    }

    public static Fields asDeclaration(Fields fields) {
        if (!fields.isDefined()) {
            return UNKNOWN;
        }
        if (fields.isOrdered()) {
            return fields;
        }
        Fields result = Fields.size(fields.size());
        Fields.copy(null, result, fields, 0);
        return result;
    }

    private static Fields asSelector(Fields fields) {
        if (!fields.isDefined()) {
            return UNKNOWN;
        }
        return fields;
    }

    private Fields() {
    }

    protected Fields(Kind kind) {
        this.kind = kind;
    }

    @ConstructorProperties(value={"fields"})
    public Fields(Comparable ... fields) {
        this.fields = this.validate(fields);
    }

    public boolean isUnOrdered() {
        return !this.isOrdered || this.kind == Kind.ALL;
    }

    public boolean isOrdered() {
        return this.isOrdered || this.kind == Kind.UNKNOWN;
    }

    public boolean isDefined() {
        return this.kind == null;
    }

    public boolean isOutSelector() {
        return this.isAll() || this.isResults() || this.isReplace() || this.isSwap() || this.isDefined();
    }

    public boolean isArgSelector() {
        return this.isAll() || this.isGroup() || this.isValues() || this.isDefined();
    }

    public boolean isDeclarator() {
        return this.isUnknown() || this.isAll() || this.isArguments() || this.isGroup() || this.isValues() || this.isDefined();
    }

    public boolean isAll() {
        return this.kind == Kind.ALL;
    }

    public boolean isUnknown() {
        return this.kind == Kind.UNKNOWN;
    }

    public boolean isArguments() {
        return this.kind == Kind.ARGS;
    }

    public boolean isValues() {
        return this.kind == Kind.VALUES;
    }

    public boolean isResults() {
        return this.kind == Kind.RESULTS;
    }

    public boolean isReplace() {
        return this.kind == Kind.REPLACE;
    }

    public boolean isSwap() {
        return this.kind == Kind.SWAP;
    }

    public boolean isGroup() {
        return this.kind == Kind.GROUP;
    }

    public boolean isSubstitution() {
        return this.isAll() || this.isArguments() || this.isGroup() || this.isValues();
    }

    private Comparable[] validate(Comparable[] fields) {
        this.isOrdered = true;
        HashSet<Comparable> names = new HashSet<Comparable>();
        for (int i = 0; i < fields.length; ++i) {
            Comparable field = fields[i];
            if (field == null) {
                throw new IllegalArgumentException("field name or position may not be null");
            }
            if (field instanceof Fields) {
                throw new IllegalArgumentException("may not nest Fields instances within a Fields instance");
            }
            if (names.contains(field)) {
                throw new IllegalArgumentException("duplicate field name found: " + field);
            }
            names.add(field);
            if (!(field instanceof Number) || (Integer)field == i) continue;
            this.isOrdered = false;
        }
        return fields;
    }

    final Comparable[] get() {
        return this.fields;
    }

    public final Comparable get(int i) {
        return this.fields[i];
    }

    final void set(int i, Comparable comparable) {
        this.fields[i] = comparable;
    }

    public int[] getPos() {
        if (this.thisPos != null) {
            return this.thisPos;
        }
        this.thisPos = this.isAll() || this.isUnknown() ? EMPTY_INT : this.makeThisPos();
        return this.thisPos;
    }

    private int[] makeThisPos() {
        int[] pos = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Comparable field = this.get(i);
            pos[i] = field instanceof Number ? (Integer)field : i;
        }
        return pos;
    }

    private final Map<Fields, int[]> getPosCache() {
        if (this.posCache == null) {
            this.posCache = new HashMap<Fields, int[]>();
        }
        return this.posCache;
    }

    private final int[] putReturn(Fields fields, int[] pos) {
        this.getPosCache().put(fields, pos);
        return pos;
    }

    final int[] getPos(Fields fields) {
        return this.getPos(fields, -1);
    }

    final int[] getPos(Fields fields, int tupleSize) {
        if (!this.isUnknown() && this.getPosCache().containsKey(fields)) {
            return this.getPosCache().get(fields);
        }
        if (fields.isAll()) {
            return this.putReturn(fields, null);
        }
        if (this.isAll()) {
            return this.putReturn(fields, fields.getPos());
        }
        if (this.size() == 0 && this.isUnknown()) {
            return this.translatePos(fields, tupleSize);
        }
        int[] pos = this.translatePos(fields, this.size());
        return this.putReturn(fields, pos);
    }

    private int[] translatePos(Fields fields, int fieldSize) {
        int[] pos = new int[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Comparable field = fields.get(i);
            pos[i] = field instanceof Number ? this.translatePos((Integer)field, fieldSize) : this.indexOf(field);
        }
        return pos;
    }

    final int translatePos(Integer integer) {
        return this.translatePos(integer, this.size());
    }

    final int translatePos(Integer integer, int size) {
        if (size == -1) {
            return integer;
        }
        if (integer < 0) {
            integer = size + integer;
        }
        if (!(this.isUnknown() || integer < size && integer >= 0)) {
            throw new TupleException("position value is too large: " + integer + ", positions in field: " + size);
        }
        return integer;
    }

    public int getPos(Comparable fieldName) {
        if (fieldName instanceof Number) {
            return this.translatePos((Integer)fieldName);
        }
        return this.indexOf(fieldName);
    }

    private final Map<Comparable, Integer> getIndex() {
        if (this.index != null) {
            return this.index;
        }
        this.index = new HashMap<Comparable, Integer>();
        for (int i = 0; i < this.size(); ++i) {
            this.index.put(this.get(i), i);
        }
        return this.index;
    }

    private int indexOf(Comparable fieldName) {
        Integer result = this.getIndex().get(fieldName);
        if (result == null) {
            throw new FieldsResolverException(this, new Fields(fieldName));
        }
        return result;
    }

    int indexOfSafe(Comparable fieldName) {
        Integer result = this.getIndex().get(fieldName);
        if (result == null) {
            return -1;
        }
        return result;
    }

    @Override
    public Iterator iterator() {
        return Collections.unmodifiableList(Arrays.asList(this.fields)).iterator();
    }

    public Fields select(Fields selector) {
        if (!this.isOrdered()) {
            throw new TupleException("this fields instance can only be used as a selector");
        }
        if (selector.isAll()) {
            return this;
        }
        if (this.isUnknown()) {
            return Fields.asSelector(selector);
        }
        Fields result = Fields.size(selector.size());
        for (int i = 0; i < selector.size(); ++i) {
            Comparable field = selector.get(i);
            if (field instanceof String) {
                result.set(i, this.get(this.indexOf(field)));
                continue;
            }
            if (this.get(this.translatePos((Integer)field)) instanceof String) {
                result.set(i, this.get(this.translatePos((Integer)field)));
                continue;
            }
            result.set(i, Integer.valueOf(this.translatePos((Integer)field)));
        }
        return result;
    }

    public Fields subtract(Fields fields) {
        int[] pos;
        Fields minus = new Fields();
        if (fields.isAll()) {
            return minus;
        }
        LinkedList list = new LinkedList();
        Collections.addAll(list, this.get());
        for (int i : pos = this.getPos(fields, -1)) {
            list.set(i, null);
        }
        Util.removeAllNulls(list);
        minus.fields = list.toArray(new Comparable[list.size()]);
        return minus;
    }

    public Fields append(Fields fields) {
        if (fields == null) {
            return this;
        }
        if (this.isAll() || fields.isAll() || !this.isOrdered() || !fields.isOrdered()) {
            throw new TupleException("cannot append fields: " + this.print() + " + " + fields.print());
        }
        if ((this.isUnknown() || this.size() == 0) && fields.isUnknown()) {
            return UNKNOWN;
        }
        HashSet<String> names = new HashSet<String>();
        Fields result = Fields.size(this.size() + fields.size());
        Fields.copy(names, result, this, 0);
        Fields.copy(names, result, fields, this.size());
        if (this.isUnknown() || fields.isUnknown()) {
            result.kind = Kind.UNKNOWN;
        }
        return result;
    }

    public Fields rename(Fields from, Fields to) {
        if (this.isSubstitution() || this.isUnknown()) {
            throw new TupleException("cannot rename fields in a substitution or unkown Fields instance: " + this.print());
        }
        if (from.size() != to.size()) {
            throw new TupleException("from and to fields must be the same size");
        }
        if (from.isSubstitution() || from.isUnknown()) {
            throw new TupleException("from fields may not be a substitution or unknown");
        }
        if (to.isSubstitution() || to.isUnknown()) {
            throw new TupleException("to fields may not be a substitution or unknown");
        }
        HashSet names = new HashSet();
        Comparable[] newFields = Arrays.copyOf(this.fields, this.fields.length);
        int[] pos = this.getPos(from);
        for (int i = 0; i < pos.length; ++i) {
            newFields[pos[i]] = to.fields[i];
        }
        return new Fields(newFields);
    }

    public Fields project(Fields fields) {
        if (fields == null) {
            return this;
        }
        Fields results = Fields.size(fields.size());
        for (int i = 0; i < fields.fields.length; ++i) {
            results.fields[i] = fields.fields[i] instanceof String ? fields.fields[i] : (this.fields[i] instanceof String ? this.fields[i] : Integer.valueOf(i));
        }
        return results;
    }

    private static void copy(Set<String> names, Fields result, Fields fields, int offset) {
        for (int i = 0; i < fields.size(); ++i) {
            Comparable field = fields.get(i);
            if (!(field instanceof String)) continue;
            if (names != null) {
                if (names.contains((String)((Object)field))) {
                    throw new TupleException("field name already exists: " + field);
                }
                names.add((String)((Object)field));
            }
            result.set(i + offset, field);
        }
    }

    public void verifyContains(Fields fields) {
        if (this.isUnknown()) {
            return;
        }
        try {
            this.getPos(fields);
        }
        catch (TupleException exception) {
            throw new TupleException("these fields " + this.print() + ", do not contain " + fields.print());
        }
    }

    public boolean contains(Fields fields) {
        try {
            this.getPos(fields);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int compareTo(Fields other) {
        if (other.size() != this.size()) {
            return other.size() < this.size() ? 1 : -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            int c = this.get(i).compareTo(other.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public int compareTo(Object other) {
        if (other instanceof Fields) {
            return this.compareTo((Fields)other);
        }
        return -1;
    }

    public String print() {
        return "[" + this.toString() + "]";
    }

    public String printVerbose() {
        return "[{" + (this.isDefined() ? Integer.valueOf(this.size()) : "?") + "}:" + this.toString() + "]";
    }

    public String toString() {
        if (this.isOrdered()) {
            return this.orderedToString();
        }
        return this.unorderedToString();
    }

    private String orderedToString() {
        StringBuffer buffer = new StringBuffer();
        if (this.size() != 0) {
            int startIndex = this.get(0) instanceof Number ? (Integer)this.get(0) : 0;
            for (int i = 0; i < this.size(); ++i) {
                Comparable field = this.get(i);
                if (field instanceof Number) {
                    if (i + 1 != this.size() && this.get(i + 1) instanceof Number) continue;
                    if (buffer.length() != 0) {
                        buffer.append(", ");
                    }
                    if (startIndex != i) {
                        buffer.append(startIndex).append(":").append(field);
                    } else {
                        buffer.append(i);
                    }
                    startIndex = i;
                    continue;
                }
                if (i != 0) {
                    buffer.append(", ");
                }
                if (field instanceof String) {
                    buffer.append("'").append(field).append("'");
                } else if (field instanceof Fields) {
                    buffer.append(((Fields)field).print());
                }
                startIndex = i + 1;
            }
        }
        if (this.kind != null) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append((Object)this.kind);
        }
        return buffer.toString();
    }

    private String unorderedToString() {
        StringBuffer buffer = new StringBuffer();
        for (Comparable field : this.get()) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            if (field instanceof String) {
                buffer.append("'").append(field).append("'");
                continue;
            }
            if (field instanceof Fields) {
                buffer.append(((Fields)field).print());
                continue;
            }
            buffer.append(field);
        }
        if (this.kind != null) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append((Object)this.kind);
        }
        return buffer.toString();
    }

    public final int size() {
        return this.fields.length;
    }

    public void setComparator(Comparable fieldName, Comparator comparator) {
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException("given comparator must be serializable");
        }
        if (this.comparators == null) {
            this.comparators = new Comparator[this.size()];
        }
        try {
            this.comparators[this.getPos((Comparable)this.asFieldName((Comparable)fieldName))] = comparator;
        }
        catch (FieldsResolverException exception) {
            throw new IllegalArgumentException("given field name was not found: " + fieldName, exception);
        }
    }

    public void setComparators(Comparator ... comparators) {
        if (comparators.length != this.size()) {
            throw new IllegalArgumentException("given number of comparator instances must match fields size");
        }
        for (Comparator comparator : comparators) {
            if (comparator instanceof Serializable) continue;
            throw new IllegalArgumentException("comparators must be serializable");
        }
        this.comparators = comparators;
    }

    private Comparable asFieldName(Comparable fieldName) {
        if (fieldName instanceof Fields) {
            Fields fields = (Fields)fieldName;
            if (!fields.isDefined()) {
                throw new TupleException("given Fields instance must explicitly declare one field name or position: " + fields.printVerbose());
            }
            fieldName = fields.get(0);
        }
        return fieldName;
    }

    public Comparator[] getComparators() {
        Comparator[] copy = new Comparator[this.size()];
        System.arraycopy(this.comparators, 0, copy, 0, this.size());
        return copy;
    }

    public boolean hasComparators() {
        return this.comparators != null;
    }

    @Override
    public int compare(Tuple lhs, Tuple rhs) {
        return lhs.compareTo(this.comparators, rhs);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Fields fields1 = (Fields)object;
        return this.kind == fields1.kind && Arrays.equals(this.get(), fields1.get());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.get() != null ? Arrays.hashCode(this.get()) : 0;
        }
        return this.hashCode;
    }

    static enum Kind {
        ALL,
        GROUP,
        VALUES,
        ARGS,
        RESULTS,
        UNKNOWN,
        REPLACE,
        SWAP;

    }
}

