/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.scheme.Scheme;
import cascading.tap.Hfs;
import cascading.tap.SinkMode;
import cascading.tuple.Fields;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;

public class Dfs
extends Hfs {
    @ConstructorProperties(value={"fields", "uri"})
    public Dfs(Fields fields, URI uri) {
        super(fields, uri.getPath());
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        this.setUriScheme(URI.create(uri.getScheme() + "://" + uri.getAuthority()));
    }

    @ConstructorProperties(value={"fields", "uri", "replace"})
    public Dfs(Fields fields, URI uri, boolean replace) {
        super(fields, uri.getPath(), replace);
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        this.setUriScheme(URI.create(uri.getScheme() + "://" + uri.getAuthority()));
    }

    @ConstructorProperties(value={"fields", "uri", "sinkMode"})
    public Dfs(Fields fields, URI uri, SinkMode sinkMode) {
        super(fields, uri.getPath(), sinkMode);
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        this.setUriScheme(URI.create(uri.getScheme() + "://" + uri.getAuthority()));
    }

    @ConstructorProperties(value={"fields", "stringPath"})
    public Dfs(Fields fields, String stringPath) {
        super(fields, stringPath);
    }

    @ConstructorProperties(value={"fields", "stringPath", "replace"})
    public Dfs(Fields fields, String stringPath, boolean replace) {
        super(fields, stringPath, replace);
    }

    @ConstructorProperties(value={"fields", "stringPath", "sinkMode"})
    public Dfs(Fields fields, String stringPath, SinkMode sinkMode) {
        super(fields, stringPath, sinkMode);
    }

    @ConstructorProperties(value={"scheme"})
    Dfs(Scheme scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"scheme", "uri"})
    public Dfs(Scheme scheme, URI uri) {
        super(scheme, uri.getPath());
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        this.setUriScheme(URI.create(uri.getScheme() + "://" + uri.getAuthority()));
    }

    @ConstructorProperties(value={"scheme", "uri", "replace"})
    public Dfs(Scheme scheme, URI uri, boolean replace) {
        super(scheme, uri.getPath(), replace);
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        this.setUriScheme(URI.create(uri.getScheme() + "://" + uri.getAuthority()));
    }

    @ConstructorProperties(value={"scheme", "uri", "sinkMode"})
    public Dfs(Scheme scheme, URI uri, SinkMode sinkMode) {
        super(scheme, uri.getPath(), sinkMode);
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        this.setUriScheme(URI.create(uri.getScheme() + "://" + uri.getAuthority()));
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Dfs(Scheme scheme, String stringPath) {
        super(scheme, stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "replace"})
    public Dfs(Scheme scheme, String stringPath, boolean replace) {
        super(scheme, stringPath, replace);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Dfs(Scheme scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, stringPath, sinkMode);
    }

    @Override
    protected void setStringPath(String stringPath) {
        if (stringPath.matches(".*://.*") && !stringPath.startsWith("hdfs://")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        super.setStringPath(stringPath);
    }

    @Override
    protected FileSystem getDefaultFileSystem(JobConf jobConf) throws IOException {
        String name = jobConf.get("fs.default.name", "hdfs://localhost:5001/");
        if (name.equals("local") || name.matches(".*://.*") && !name.startsWith("hdfs://")) {
            name = "hdfs://localhost:5001/";
        } else if (name.indexOf(47) == -1) {
            name = "hdfs://" + name;
        }
        return FileSystem.get((URI)URI.create(name), (Configuration)jobConf);
    }
}

