/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.text;

import cascading.flow.FlowProcess;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.text.DateOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatter
extends DateOperation
implements Function {
    public static final String FIELD_NAME = "datetime";

    @ConstructorProperties(value={"dateFormatString"})
    public DateFormatter(String dateFormatString) {
        super(1, new Fields(new Comparable[]{FIELD_NAME}), dateFormatString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "dateFormatString"})
    public DateFormatter(Fields fieldDeclaration, String dateFormatString) {
        super(1, fieldDeclaration, dateFormatString);
    }

    @ConstructorProperties(value={"fieldDeclaration", "dateFormatString", "zone"})
    public DateFormatter(Fields fieldDeclaration, String dateFormatString, TimeZone zone) {
        super(1, fieldDeclaration, dateFormatString, zone, null);
    }

    @ConstructorProperties(value={"fieldDeclaration", "dateFormatString", "zone", "locale"})
    public DateFormatter(Fields fieldDeclaration, String dateFormatString, TimeZone zone, Locale locale) {
        super(1, fieldDeclaration, dateFormatString, zone, locale);
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        Tuple output = new Tuple();
        long ts = functionCall.getArguments().getLong(Integer.valueOf(0));
        Calendar calendar = this.getCalendar();
        calendar.setTimeInMillis(ts);
        output.add(this.getDateFormat().format(calendar.getTime()));
        functionCall.getOutputCollector().add(output);
    }
}

