/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;

public abstract class Logic
extends BaseOperation
implements Filter {
    protected final Fields[] argumentSelectors;
    protected final Filter[] filters;
    private transient TupleEntry[] argumentEntries;

    private static Filter[] filters(Filter ... filters) {
        return filters;
    }

    @ConstructorProperties(value={"filters"})
    protected Logic(Filter ... filters) {
        this.filters = filters;
        if (filters == null) {
            throw new IllegalArgumentException("given filters array must not be null");
        }
        this.argumentSelectors = new Fields[filters.length];
        Arrays.fill(this.argumentSelectors, Fields.ALL);
        this.verify();
        this.numArgs = this.getFieldsSize();
    }

    @ConstructorProperties(value={"lhsArgumentsSelector", "lhsFilter", "rhsArgumentSelector", "rhsFilter"})
    protected Logic(Fields lhsArgumentSelector, Filter lhsFilter, Fields rhsArgumentSelector, Filter rhsFilter) {
        this(Fields.fields(lhsArgumentSelector, rhsArgumentSelector), Logic.filters(lhsFilter, rhsFilter));
    }

    @ConstructorProperties(value={"argumentSelectors", "filters"})
    protected Logic(Fields[] argumentSelectors, Filter[] filters) {
        this.argumentSelectors = argumentSelectors;
        this.filters = filters;
        this.verify();
        this.numArgs = this.getFieldsSize();
    }

    protected void verify() {
        if (this.argumentSelectors == null) {
            throw new IllegalArgumentException("given argumentSelectors array must not be null");
        }
        if (this.filters == null) {
            throw new IllegalArgumentException("given filters array must not be null");
        }
        for (Fields field : this.argumentSelectors) {
            if (field == null) {
                throw new IllegalArgumentException("given argumentSelectors must not be null");
            }
            if (field.isAll() || field.isDefined()) continue;
            throw new IllegalArgumentException("given argumentSelectors must be ALL or 'defined' selectors, got: " + field.print());
        }
        for (Filter filter : this.filters) {
            if (filter != null) continue;
            throw new IllegalArgumentException("given filters must not be null");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        Object[] contexts = new Object[this.filters.length];
        for (int i = 0; i < this.filters.length; ++i) {
            Filter filter = this.filters[i];
            filter.prepare(flowProcess, operationCall);
            contexts[i] = operationCall.getContext();
            operationCall.setContext(null);
        }
        operationCall.setContext(contexts);
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        Object[] contexts = (Object[])operationCall.getContext();
        for (int i = 0; i < this.filters.length; ++i) {
            Filter filter = this.filters[i];
            operationCall.setContext(contexts[i]);
            filter.cleanup(flowProcess, operationCall);
        }
    }

    protected int getFieldsSize() {
        HashSet<Comparable> pos = new HashSet<Comparable>();
        for (Fields field : this.argumentSelectors) {
            if (field.isSubstitution()) {
                return Integer.MAX_VALUE;
            }
            for (int i = 0; i < field.size(); ++i) {
                pos.add(field.get(i));
            }
        }
        return pos.size();
    }

    protected final TupleEntry[] getArgumentEntries() {
        if (this.argumentEntries != null) {
            return this.argumentEntries;
        }
        this.argumentEntries = new TupleEntry[this.argumentSelectors.length];
        for (int i = 0; i < this.argumentSelectors.length; ++i) {
            Fields argumentSelector = this.argumentSelectors[i];
            this.argumentEntries[i] = new TupleEntry(Fields.asDeclaration(argumentSelector));
        }
        return this.argumentEntries;
    }
}

