/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;

public class ExpressionOperation
extends BaseOperation<Context> {
    protected String expression;
    private Class[] parameterTypes;
    private String[] parameterNames;

    @ConstructorProperties(value={"fieldDeclaration", "expression"})
    protected ExpressionOperation(Fields fieldDeclaration, String expression) {
        super(fieldDeclaration);
        this.parameterTypes = new Class[0];
        this.expression = expression;
    }

    @ConstructorProperties(value={"fieldDeclaration", "expression", "parameterType"})
    protected ExpressionOperation(Fields fieldDeclaration, String expression, Class parameterType) {
        super(fieldDeclaration);
        this.parameterTypes = new Class[]{parameterType};
        this.expression = expression;
    }

    @ConstructorProperties(value={"fieldDeclaration", "expression", "parameterNames", "parameterTypes"})
    protected ExpressionOperation(Fields fieldDeclaration, String expression, String[] parameterNames, Class[] parameterTypes) {
        super(parameterTypes.length, fieldDeclaration);
        this.parameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        this.parameterNames = Arrays.copyOf(parameterNames, parameterNames.length);
        this.expression = expression;
        if (parameterNames.length != parameterTypes.length) {
            throw new IllegalArgumentException("parameterNames must be same length as parameterTypes");
        }
    }

    @ConstructorProperties(value={"fieldDeclaration", "parameterType"})
    protected ExpressionOperation(String expression, Class parameterType) {
        this.parameterTypes = new Class[]{parameterType};
        this.expression = expression;
    }

    @ConstructorProperties(value={"expression", "parameterNames", "parameterTypes"})
    protected ExpressionOperation(String expression, String[] parameterNames, Class[] parameterTypes) {
        super(parameterTypes.length);
        this.parameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        this.parameterNames = Arrays.copyOf(parameterNames, parameterNames.length);
        this.expression = expression;
        if (parameterNames.length != parameterTypes.length) {
            throw new IllegalArgumentException("parameterNames must be same length as parameterTypes");
        }
    }

    private String[] getParameterNames() {
        if (this.parameterNames != null) {
            return this.parameterNames;
        }
        try {
            this.parameterNames = ExpressionEvaluator.guessParameterNames(new Scanner("expressionEval", new StringReader(this.expression)));
        }
        catch (Parser.ParseException exception) {
            throw new OperationException("could not parse expression: " + this.expression, exception);
        }
        catch (Scanner.ScanException exception) {
            throw new OperationException("could not scan expression: " + this.expression, exception);
        }
        catch (IOException exception) {
            throw new OperationException("could not read expression: " + this.expression, exception);
        }
        return this.parameterNames;
    }

    private Fields getParameterFields() {
        return this.makeFields(this.getParameterNames());
    }

    private Class[] getParameterTypes(String[] parameterNames) {
        if (parameterNames.length == this.parameterTypes.length) {
            return this.parameterTypes;
        }
        if (this.parameterTypes.length != 1) {
            throw new IllegalStateException("wrong number of parameter types, expects: " + parameterNames.length);
        }
        Object[] types = new Class[parameterNames.length];
        Arrays.fill(types, this.parameterTypes[0]);
        this.parameterTypes = types;
        return this.parameterTypes;
    }

    private ExpressionEvaluator getExpressionEvaluator(String[] parameterNames, Class[] parameterTypes) {
        try {
            return new ExpressionEvaluator(this.expression, Comparable.class, parameterNames, parameterTypes);
        }
        catch (CompileException exception) {
            throw new OperationException("could not compile expression: " + this.expression, exception);
        }
        catch (Parser.ParseException exception) {
            throw new OperationException("could not parse expression: " + this.expression, exception);
        }
        catch (Scanner.ScanException exception) {
            throw new OperationException("could not scan expression: " + this.expression, exception);
        }
    }

    private Fields makeFields(String[] parameters) {
        Comparable[] fields = new Comparable[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String parameter = parameters[i];
            fields[i] = parameter.startsWith("$") ? Integer.valueOf(Integer.parseInt(parameter.substring(1))) : parameter;
        }
        return new Fields(fields);
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        if (operationCall.getContext() == null) {
            operationCall.setContext(new Context());
        }
        Context context = operationCall.getContext();
        Context.access$002(context, this.getParameterNames());
        context.parameterFields = this.getParameterFields();
        Context.access$202(context, this.getParameterTypes(context.parameterNames));
        context.expressionEvaluator = this.getExpressionEvaluator(context.parameterNames, context.parameterTypes);
    }

    protected Comparable evaluate(Context context, TupleEntry input) {
        try {
            if (context.parameterTypes.length == 0) {
                return (Comparable)context.expressionEvaluator.evaluate(null);
            }
            Tuple parameterTuple = input.selectTuple(context.parameterFields);
            return (Comparable)context.expressionEvaluator.evaluate(Tuples.asArray(parameterTuple, context.parameterTypes));
        }
        catch (InvocationTargetException exception) {
            throw new OperationException("could not evaluate expression: " + this.expression, exception);
        }
    }

    public static class Context {
        private Class[] parameterTypes;
        private ExpressionEvaluator expressionEvaluator;
        private Fields parameterFields;
        private String[] parameterNames;

        static /* synthetic */ String[] access$002(Context x0, String[] x1) {
            x0.parameterNames = x1;
            return x1;
        }

        static /* synthetic */ Class[] access$202(Context x0, Class[] x1) {
            x0.parameterTypes = x1;
            return x1;
        }
    }
}

