/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowCollector;
import cascading.flow.FlowProcess;
import cascading.flow.StepCounters;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.stack.StackException;
import cascading.tap.Tap;
import cascading.tap.hadoop.TapCollector;
import cascading.tuple.TupleEntry;
import cascading.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

abstract class StackElement
implements FlowCollector {
    private static final Logger LOG = Logger.getLogger(StackElement.class);
    private static Map<Tap, TapCollector> trapCollectors = new HashMap<Tap, TapCollector>();
    final FlowProcess flowProcess;
    private String trapName;
    private final Tap trap;
    StackElement previous;
    StackElement next;

    private static TapCollector getTrapCollector(Tap trap, JobConf jobConf) {
        TapCollector trapCollector = trapCollectors.get(trap);
        if (trapCollector == null) {
            try {
                jobConf = new JobConf((Configuration)jobConf);
                int id = jobConf.getInt("cascading.flow.step.id", 0);
                String partname = jobConf.getBoolean("mapred.task.is.map", true) ? String.format("-m-%05d-", id) : String.format("-r-%05d-", id);
                jobConf.set("cascading.tapcollector.partname", "%s%spart" + partname + "%05d");
                trapCollector = (TapCollector)trap.openForWrite(jobConf);
                trapCollectors.put(trap, trapCollector);
            }
            catch (IOException exception) {
                throw new StackException(exception);
            }
        }
        return trapCollector;
    }

    private static void closeTraps() {
        for (TapCollector trapCollector : trapCollectors.values()) {
            try {
                trapCollector.close();
            }
            catch (Exception exception) {}
        }
        trapCollectors.clear();
    }

    public StackElement(FlowProcess flowProcess, String trapName, Tap trap) {
        this.flowProcess = flowProcess;
        this.trapName = trapName;
        this.trap = trap;
    }

    public StackElement resolveStack() {
        if (this.previous != null) {
            return this.previous.setNext(this);
        }
        return this;
    }

    StackElement setNext(StackElement next) {
        this.next = next;
        if (this.previous != null) {
            return this.previous.setNext(this);
        }
        return this;
    }

    public abstract void prepare();

    public abstract void cleanup();

    public FlowProcess getFlowProcess() {
        return this.flowProcess;
    }

    public JobConf getJobConf() {
        return ((HadoopFlowProcess)this.flowProcess).getJobConf();
    }

    protected void handleException(Exception exception, TupleEntry tupleEntry) {
        this.handleException(this.trapName, this.trap, exception, tupleEntry);
    }

    protected void handleException(String trapName, Tap trap, Exception exception, TupleEntry tupleEntry) {
        if (exception instanceof StackException) {
            throw (StackException)exception;
        }
        if (trap == null) {
            throw new StackException(exception);
        }
        if (tupleEntry == null) {
            LOG.error((Object)"failure resolving tuple entry", (Throwable)exception);
            throw new StackException("failure resolving tuple entry", exception);
        }
        StackElement.getTrapCollector(trap, this.getJobConf()).add(tupleEntry);
        this.getFlowProcess().increment(StepCounters.Tuples_Trapped, 1);
        LOG.warn((Object)("exception trap on branch: '" + trapName + "', for " + Util.truncate(this.print(tupleEntry), 75)), (Throwable)exception);
    }

    private String print(TupleEntry tupleEntry) {
        if (tupleEntry == null || tupleEntry.getFields() == null) {
            return "[uninitialized]";
        }
        if (tupleEntry.getTuple() == null) {
            return "fields: " + tupleEntry.getFields().printVerbose();
        }
        return "fields: " + tupleEntry.getFields().printVerbose() + " tuple: " + tupleEntry.getTuple().print();
    }

    public void open() throws IOException {
        this.prepare();
        if (this.previous != null) {
            this.previous.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.cleanup();
        }
        finally {
            try {
                if (this.next == null) {
                    StackElement.closeTraps();
                }
            }
            finally {
                if (this.next != null) {
                    this.next.close();
                }
            }
        }
    }
}

