/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.DeserializerComparator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.Util;
import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;

public class TupleComparator
extends DeserializerComparator<Tuple>
implements Configurable {
    private Comparator comparator = new Comparator<Tuple>(){

        @Override
        public int compare(Tuple lhs, Tuple rhs) {
            return lhs.compareTo(rhs);
        }
    };

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        try {
            String value = conf.get("cascading.group.comparator");
            if (value != null) {
                this.comparator = (Comparator)Util.deserializeBase64(value);
            }
        }
        catch (IOException exception) {
            throw new CascadingException("unable to deserialize grouping comparator");
        }
    }

    @Override
    void setDeserializer(TupleSerialization tupleSerialization) throws IOException {
        this.setDeserializer(tupleSerialization.getTupleDeserializer());
    }

    public int compare(Tuple lhs, Tuple rhs) {
        return this.comparator.compare(lhs, rhs);
    }
}

