/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleIterator;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.log4j.Logger;

public class TapIterator
implements TupleIterator {
    private static final Logger LOG = Logger.getLogger(TapIterator.class);
    private final Tap tap;
    private InputFormat inputFormat;
    private final JobConf conf;
    private InputSplit[] splits;
    private RecordReader reader;
    private Object key;
    private Object value;
    private int currentSplit = 0;
    private Tuple currentTuple;
    private boolean complete = false;

    public TapIterator(Tap tap, JobConf conf) throws IOException {
        this.tap = tap;
        this.conf = new JobConf((Configuration)conf);
        this.initalize();
    }

    private void initalize() throws IOException {
        this.tap.sourceInit(this.conf);
        if (!this.tap.pathExists(this.conf)) {
            this.complete = true;
            return;
        }
        this.inputFormat = this.conf.getInputFormat();
        if (this.inputFormat instanceof JobConfigurable) {
            ((JobConfigurable)this.inputFormat).configure(this.conf);
        }
        this.splits = this.inputFormat.getSplits(this.conf, 1);
        if (this.splits.length == 0) {
            this.complete = true;
            return;
        }
        this.reader = this.makeReader(this.currentSplit);
        this.key = this.reader.createKey();
        this.value = this.reader.createValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found splits: " + this.splits.length));
            LOG.debug((Object)("using key: " + this.key.getClass().getName()));
            LOG.debug((Object)("using value: " + this.value.getClass().getName()));
        }
    }

    private RecordReader makeReader(int currentSplit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading split: " + currentSplit));
        }
        return this.inputFormat.getRecordReader(this.splits[currentSplit], this.conf, Reporter.NULL);
    }

    @Override
    public boolean hasNext() {
        this.getNextTuple();
        return !this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple next() {
        try {
            this.getNextTuple();
            Tuple tuple = this.currentTuple;
            return tuple;
        }
        finally {
            this.currentTuple = null;
        }
    }

    private void getNextTuple() {
        if (this.currentTuple != null || this.reader == null) {
            return;
        }
        try {
            if (this.reader.next(this.key, this.value)) {
                this.currentTuple = this.tap.source(this.key, this.value);
                this.getNextTuple();
            } else if (this.currentSplit < this.splits.length - 1) {
                this.reader.close();
                this.reader = this.makeReader(++this.currentSplit);
                this.getNextTuple();
            } else {
                this.complete = true;
            }
        }
        catch (IOException exception) {
            throw new TapException("could not get next tuple", exception);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException exception) {
            LOG.warn((Object)"exception closing iteraor", (Throwable)exception);
        }
    }
}

