/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme;

import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class SequenceFile
extends Scheme {
    private static final long serialVersionUID = 1L;

    protected SequenceFile() {
        super(null);
    }

    @ConstructorProperties(value={"fields"})
    public SequenceFile(Fields fields) {
        super(fields);
    }

    @Override
    public void sourceInit(Tap tap, JobConf conf) {
        conf.setInputFormat(SequenceFileInputFormat.class);
    }

    @Override
    public void sinkInit(Tap tap, JobConf conf) {
        conf.setOutputKeyClass(Tuple.class);
        conf.setOutputValueClass(Tuple.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
    }

    @Override
    public Tuple source(Object key, Object value) {
        return (Tuple)value;
    }

    @Override
    public Fields getSinkFields() {
        return super.getSourceFields();
    }

    @Override
    public void sink(TupleEntry tupleEntry, OutputCollector outputCollector) throws IOException {
        Tuple result = this.getSinkFields() != null ? tupleEntry.selectTuple(this.getSinkFields()) : tupleEntry.getTuple();
        outputCollector.collect((Object)Tuples.NULL, (Object)result);
    }
}

