/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.filter;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import java.beans.ConstructorProperties;
import java.util.Random;

public class Sample
extends BaseOperation<Random>
implements Filter<Random> {
    private long seed = System.currentTimeMillis();
    private double fraction = 1.0;

    @ConstructorProperties(value={"fraction"})
    public Sample(double fraction) {
        this.fraction = fraction;
    }

    @ConstructorProperties(value={"seed", "fraction"})
    public Sample(long seed, double fraction) {
        this.seed = seed;
        this.fraction = fraction;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Random> operationCall) {
        super.prepare(flowProcess, operationCall);
        operationCall.setContext(new Random(this.seed));
    }

    @Override
    public boolean isRemove(FlowProcess flowProcess, FilterCall<Random> filterCall) {
        return !(((Random)filterCall.getContext()).nextDouble() < this.fraction);
    }
}

