/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.aggregator;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class ExtremaBase
extends BaseOperation<Context>
implements Aggregator<Context> {
    protected final Collection ignoreValues;

    @ConstructorProperties(value={"fieldDeclaration"})
    public ExtremaBase(Fields fieldDeclaration) {
        super(fieldDeclaration);
        this.ignoreValues = null;
    }

    @ConstructorProperties(value={"numArgs", "fieldDeclaration"})
    public ExtremaBase(int numArgs, Fields fieldDeclaration) {
        super(numArgs, fieldDeclaration);
        this.ignoreValues = null;
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare 1 field, got: " + fieldDeclaration.size());
        }
    }

    @ConstructorProperties(value={"fieldDeclaration", "ignoreValues"})
    protected ExtremaBase(Fields fieldDeclaration, Object ... ignoreValues) {
        super(fieldDeclaration);
        this.ignoreValues = new HashSet();
        Collections.addAll(this.ignoreValues, ignoreValues);
    }

    @Override
    public void start(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        if (aggregatorCall.getContext() == null) {
            aggregatorCall.setContext(new Context(this.getInitialValue()));
        } else {
            ((Context)aggregatorCall.getContext()).reset(this.getInitialValue());
        }
    }

    protected abstract double getInitialValue();

    @Override
    public void aggregate(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        TupleEntry entry = aggregatorCall.getArguments();
        Context context = (Context)aggregatorCall.getContext();
        Comparable arg = entry.get(0);
        if (this.ignoreValues != null && this.ignoreValues.contains(arg)) {
            return;
        }
        Number rhs = null;
        Number lhs = context.extrema;
        rhs = arg instanceof Number ? (Number)((Number)((Object)arg)) : (Number)entry.getDouble(Integer.valueOf(0));
        if (this.compare(lhs, rhs)) {
            context.value = arg;
            context.extrema = rhs;
        }
    }

    protected abstract boolean compare(Number var1, Number var2);

    @Override
    public void complete(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        aggregatorCall.getOutputCollector().add(this.getResult(aggregatorCall));
    }

    protected Tuple getResult(AggregatorCall<Context> aggregatorCall) {
        return new Tuple((Comparable)((Context)aggregatorCall.getContext()).value);
    }

    protected static class Context {
        Number extrema;
        Object value;

        public Context(Number extrema) {
            this.extrema = extrema;
        }

        public Context reset(Number extrema) {
            this.extrema = extrema;
            this.value = null;
            return this;
        }
    }
}

