/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.FlowElement;
import cascading.flow.FlowMapper;
import cascading.flow.FlowReducer;
import cascading.flow.FlowStepJob;
import cascading.flow.Scope;
import cascading.operation.Operation;
import cascading.pipe.Group;
import cascading.pipe.Operator;
import cascading.pipe.Pipe;
import cascading.tap.Tap;
import cascading.tap.TempHfs;
import cascading.tap.hadoop.Hadoop18TapUtil;
import cascading.tap.hadoop.MultiInputFormat;
import cascading.tap.hadoop.TapIterator;
import cascading.tuple.Fields;
import cascading.tuple.IndexTuple;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TuplePair;
import cascading.tuple.hadoop.CoGroupingComparator;
import cascading.tuple.hadoop.CoGroupingPartitioner;
import cascading.tuple.hadoop.GroupingComparator;
import cascading.tuple.hadoop.GroupingPartitioner;
import cascading.tuple.hadoop.IndexTupleCoGroupingComparator;
import cascading.tuple.hadoop.ReverseTupleComparator;
import cascading.tuple.hadoop.ReverseTuplePairComparator;
import cascading.tuple.hadoop.TupleComparator;
import cascading.tuple.hadoop.TuplePairComparator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.jgrapht.graph.SimpleDirectedGraph;

public class FlowStep
implements Serializable {
    private static final Logger LOG = Logger.getLogger(FlowStep.class);
    private Map<Object, Object> properties = null;
    private String parentFlowName;
    private int submitPriority = 5;
    final String name;
    private int id;
    final SimpleDirectedGraph<FlowElement, Scope> graph = new SimpleDirectedGraph(Scope.class);
    final Map<Tap, String> sources = new HashMap<Tap, String>();
    protected Tap sink;
    public final Map<String, Tap> mapperTraps = new HashMap<String, Tap>();
    public final Map<String, Tap> reducerTraps = new HashMap<String, Tap>();
    TempHfs tempSink;
    public Group group;

    protected FlowStep(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParentFlowName() {
        return this.parentFlowName;
    }

    public void setParentFlowName(String parentFlowName) {
        this.parentFlowName = parentFlowName;
    }

    public String getStepName() {
        return String.format("%s[%s]", this.getParentFlowName(), this.getName());
    }

    public int getSubmitPriority() {
        return this.submitPriority;
    }

    public void setSubmitPriority(int submitPriority) {
        this.submitPriority = submitPriority;
    }

    public Map<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setProperties(Map<Object, Object> properties) {
        this.properties = properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    protected JobConf getJobConf() throws IOException {
        return this.getJobConf(null);
    }

    protected JobConf getJobConf(JobConf parentConf) throws IOException {
        JobConf conf;
        JobConf jobConf = conf = parentConf == null ? new JobConf() : new JobConf((Configuration)parentConf);
        if (this.hasProperties()) {
            for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
                conf.set(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        conf.setJobName(this.getStepName());
        conf.setOutputKeyClass(Tuple.class);
        conf.setOutputValueClass(Tuple.class);
        conf.setMapperClass(FlowMapper.class);
        conf.setReducerClass(FlowReducer.class);
        TupleSerialization.setSerializations(conf);
        this.initFromSources(conf);
        this.initFromSink(conf);
        this.initFromTraps(conf);
        if (this.sink.getScheme().getNumSinkParts() != 0) {
            if (this.group != null) {
                conf.setNumReduceTasks(this.sink.getScheme().getNumSinkParts());
            } else {
                conf.setNumMapTasks(this.sink.getScheme().getNumSinkParts());
            }
        }
        conf.setOutputKeyComparatorClass(TupleComparator.class);
        if (this.group == null) {
            conf.setNumReduceTasks(0);
        } else {
            conf.setMapOutputKeyClass(Tuple.class);
            conf.setMapOutputValueClass(Tuple.class);
            if (this.group.isSortReversed()) {
                conf.setOutputKeyComparatorClass(ReverseTupleComparator.class);
            }
            this.addComparators(conf, "cascading.group.comparator", this.group.getGroupingSelectors());
            if (this.group.isGroupBy()) {
                this.addComparators(conf, "cascading.sort.comparator", this.group.getSortingSelectors());
            }
            if (!this.group.isGroupBy()) {
                conf.setPartitionerClass(CoGroupingPartitioner.class);
                conf.setMapOutputKeyClass(IndexTuple.class);
                conf.setMapOutputValueClass(IndexTuple.class);
                conf.setOutputKeyComparatorClass(IndexTupleCoGroupingComparator.class);
                conf.setOutputValueGroupingComparator(CoGroupingComparator.class);
            }
            if (this.group.isSorted()) {
                conf.setPartitionerClass(GroupingPartitioner.class);
                conf.setMapOutputKeyClass(TuplePair.class);
                if (this.group.isSortReversed()) {
                    conf.setOutputKeyComparatorClass(ReverseTuplePairComparator.class);
                } else {
                    conf.setOutputKeyComparatorClass(TuplePairComparator.class);
                }
                conf.setOutputValueGroupingComparator(GroupingComparator.class);
            }
        }
        conf.setInt("cascading.flow.step.id", this.id);
        conf.set("cascading.flow.step", Util.serializeBase64(this));
        return conf;
    }

    private void addComparators(JobConf conf, String property, Map<String, Fields> map) throws IOException {
        Iterator<Fields> fieldsIterator = map.values().iterator();
        if (!fieldsIterator.hasNext()) {
            return;
        }
        Fields fields = fieldsIterator.next();
        if (fields.hasComparators()) {
            conf.set(property, Util.serializeBase64(fields));
        }
    }

    private void initFromTraps(JobConf conf) throws IOException {
        this.initFromTraps(conf, this.mapperTraps);
        this.initFromTraps(conf, this.reducerTraps);
    }

    private void initFromTraps(JobConf conf, Map<String, Tap> traps) throws IOException {
        if (!traps.isEmpty()) {
            JobConf trapConf = new JobConf((Configuration)conf);
            for (Tap tap : traps.values()) {
                tap.sinkInit(trapConf);
            }
        }
    }

    private void initFromSources(JobConf conf) throws IOException {
        JobConf[] fromJobs = new JobConf[this.sources.size()];
        int i = 0;
        for (Tap tap : this.sources.keySet()) {
            fromJobs[i] = new JobConf((Configuration)conf);
            tap.sourceInit(fromJobs[i]);
            fromJobs[i].set("cascading.step.source", Util.serializeBase64(tap));
            ++i;
        }
        MultiInputFormat.addInputFormat(conf, fromJobs);
    }

    private void initFromSink(JobConf conf) throws IOException {
        if (this.sink != null) {
            this.sink.sinkInit(conf);
        }
        if (this.tempSink != null) {
            this.tempSink.sinkInit(conf);
        }
    }

    public TapIterator openSourceForRead(JobConf conf) throws IOException {
        return new TapIterator(this.sources.keySet().iterator().next(), conf);
    }

    public TupleEntryIterator openSinkForRead(JobConf conf) throws IOException {
        return this.sink.openForRead(conf);
    }

    public Tap getMapperTrap(String name) {
        return this.mapperTraps.get(name);
    }

    public Tap getReducerTrap(String name) {
        return this.reducerTraps.get(name);
    }

    public Set<Scope> getPreviousScopes(FlowElement flowElement) {
        return this.graph.incomingEdgesOf(flowElement);
    }

    public Scope getNextScope(FlowElement flowElement) {
        Set set = this.graph.outgoingEdgesOf(flowElement);
        if (set.size() != 1) {
            throw new IllegalStateException("should only be one scope after current flow element: " + flowElement + " found: " + set.size());
        }
        return (Scope)set.iterator().next();
    }

    public Set<Scope> getNextScopes(FlowElement flowElement) {
        return this.graph.outgoingEdgesOf(flowElement);
    }

    public FlowElement getNextFlowElement(Scope scope) {
        return (FlowElement)this.graph.getEdgeTarget(scope);
    }

    public String getSourceName(Tap source) {
        return this.sources.get(source);
    }

    public Collection<Operation> getAllOperations() {
        Set vertices = this.graph.vertexSet();
        HashSet<Operation> operations = new HashSet<Operation>();
        for (FlowElement vertice : vertices) {
            if (!(vertice instanceof Operator)) continue;
            operations.add(((Operator)vertice).getOperation());
        }
        return operations;
    }

    public boolean containsPipeNamed(String pipeName) {
        Set vertices = this.graph.vertexSet();
        for (FlowElement vertice : vertices) {
            if (!(vertice instanceof Pipe) || !((Pipe)vertice).getName().equals(pipeName)) continue;
            return true;
        }
        return false;
    }

    public void clean(JobConf jobConf) {
        if (this.tempSink != null) {
            try {
                this.tempSink.deletePath(jobConf);
            }
            catch (Exception exception) {
                this.logWarn("unable to remove temporary file: " + this.tempSink, exception);
            }
        }
        if (this.sink instanceof TempHfs) {
            try {
                this.sink.deletePath(jobConf);
            }
            catch (Exception exception) {
                this.logWarn("unable to remove temporary file: " + this.sink, exception);
            }
        } else {
            this.cleanTap(jobConf, this.sink);
        }
        for (Tap tap : this.mapperTraps.values()) {
            this.cleanTap(jobConf, tap);
        }
        for (Tap tap : this.reducerTraps.values()) {
            this.cleanTap(jobConf, tap);
        }
    }

    private void cleanTap(JobConf jobConf, Tap tap) {
        try {
            Hadoop18TapUtil.cleanupTap(jobConf, tap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FlowStep flowStep = (FlowStep)object;
        return !(this.name != null ? !this.name.equals(flowStep.name) : flowStep.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("[name: ").append(this.getName()).append("]");
        return buffer.toString();
    }

    protected FlowStepJob createFlowStepJob(JobConf parentConf) throws IOException {
        return new FlowStepJob(this, this.getName(), this.getJobConf(parentConf));
    }

    protected final boolean isInfoEnabled() {
        return LOG.isInfoEnabled();
    }

    protected final boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    protected void logDebug(String message) {
        LOG.debug((Object)("[" + Util.truncate(this.getParentFlowName(), 25) + "] " + message));
    }

    protected void logInfo(String message) {
        LOG.info((Object)("[" + Util.truncate(this.getParentFlowName(), 25) + "] " + message));
    }

    protected void logWarn(String message) {
        LOG.warn((Object)("[" + Util.truncate(this.getParentFlowName(), 25) + "] " + message));
    }

    protected void logWarn(String message, Throwable throwable) {
        LOG.warn((Object)("[" + Util.truncate(this.getParentFlowName(), 25) + "] " + message), throwable);
    }

    protected void logError(String message, Throwable throwable) {
        LOG.error((Object)("[" + Util.truncate(this.getParentFlowName(), 25) + "] " + message), throwable);
    }
}

