/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.tuple.IndexTuple;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.DeserializerComparator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.Util;
import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;

public class CoGroupingComparator
extends DeserializerComparator<IndexTuple> {
    private Comparator comparator = new Comparator<Tuple>(){

        @Override
        public int compare(Tuple lhs, Tuple rhs) {
            return lhs.compareTo(rhs);
        }
    };

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        String group = conf.get("cascading.group.comparator");
        if (group == null) {
            return;
        }
        try {
            if (group != null) {
                this.comparator = (Comparator)Util.deserializeBase64(group);
            }
        }
        catch (IOException exception) {
            throw new CascadingException("unable to deserialize grouping comparator");
        }
    }

    @Override
    void setDeserializer(TupleSerialization tupleSerialization) throws IOException {
        this.setDeserializer(tupleSerialization.getIndexTupleDeserializer());
    }

    public int compare(IndexTuple lhs, IndexTuple rhs) {
        return this.comparator.compare(lhs.getTuple(), rhs.getTuple());
    }
}

