/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.tap.hadoop.MultiInputFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.util.ReflectionUtils;

public class MultiInputSplit
implements InputSplit,
JobConfigurable {
    private transient JobConf jobConf;
    InputSplit inputSplit;
    Map<String, String> config;

    public static String getCurrentTapSourcePath(JobConf jobConf) {
        return jobConf.get("cascading.source.path");
    }

    public MultiInputSplit(InputSplit inputSplit, Map<String, String> config) {
        this.inputSplit = inputSplit;
        this.config = config;
    }

    public MultiInputSplit() {
    }

    public void configure(JobConf jobConf) {
        this.jobConf = jobConf;
    }

    public long getLength() throws IOException {
        return this.inputSplit.getLength();
    }

    public String[] getLocations() throws IOException {
        return this.inputSplit.getLocations();
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.inputSplit.getClass().getName());
        String[] keys = this.config.keySet().toArray(new String[this.config.size()]);
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = this.config.get(keys[i]);
        }
        WritableUtils.writeStringArray((DataOutput)out, (String[])keys);
        WritableUtils.writeStringArray((DataOutput)out, (String[])values);
        this.inputSplit.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        Path path;
        String splitType = in.readUTF();
        this.config = new HashMap<String, String>();
        String[] keys = WritableUtils.readStringArray((DataInput)in);
        String[] values = WritableUtils.readStringArray((DataInput)in);
        for (int i = 0; i < keys.length; ++i) {
            this.config.put(keys[i], values[i]);
        }
        JobConf currentConf = MultiInputFormat.mergeConf(this.jobConf, this.config, false);
        try {
            this.inputSplit = (InputSplit)ReflectionUtils.newInstance((Class)currentConf.getClassByName(splitType), (Configuration)currentConf);
        }
        catch (ClassNotFoundException exp) {
            throw new IOException("Split class " + splitType + " not found");
        }
        this.inputSplit.readFields(in);
        if (this.inputSplit instanceof FileSplit && (path = ((FileSplit)this.inputSplit).getPath()) != null) {
            this.jobConf.set("cascading.source.path", path.toString());
        }
    }
}

