/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.scheme.Scheme;
import cascading.tap.CompositeTap;
import cascading.tap.SourceTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class MultiSourceTap
extends SourceTap
implements CompositeTap {
    protected Tap[] taps;

    protected MultiSourceTap(Scheme scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"taps"})
    public MultiSourceTap(Tap ... taps) {
        this.taps = Arrays.copyOf(taps, taps.length);
        this.verifyTaps();
    }

    private void verifyTaps() {
        Tap tap = this.taps[0];
        for (int i = 1; i < this.taps.length; ++i) {
            if (tap.getClass() != this.taps[i].getClass()) {
                throw new TapException("all taps must be of the same type");
            }
            if (tap.getScheme().equals(this.taps[i].getScheme())) continue;
            throw new TapException("all tap schemes must be equivalent");
        }
    }

    protected Tap[] getTaps() {
        return this.taps;
    }

    @Override
    public Tap[] getChildTaps() {
        return Arrays.copyOf(this.getTaps(), this.getTaps().length);
    }

    @Override
    public Path getPath() {
        return null;
    }

    @Override
    public Scheme getScheme() {
        Scheme scheme = super.getScheme();
        if (scheme != null) {
            return scheme;
        }
        return this.taps[0].getScheme();
    }

    @Override
    public boolean isReplace() {
        return false;
    }

    @Override
    public void sourceInit(JobConf conf) throws IOException {
        for (Tap tap : this.getTaps()) {
            tap.sourceInit(conf);
        }
    }

    @Override
    public boolean pathExists(JobConf conf) throws IOException {
        for (Tap tap : this.getTaps()) {
            if (!tap.pathExists(conf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getPathModified(JobConf conf) throws IOException {
        Tap[] taps = this.getTaps();
        if (taps == null || taps.length == 0) {
            return 0L;
        }
        long modified = taps[0].getPathModified(conf);
        for (int i = 1; i < this.getTaps().length; ++i) {
            modified = Math.max(this.getTaps()[i].getPathModified(conf), modified);
        }
        return modified;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MultiSourceTap multiTap = (MultiSourceTap)object;
        return Arrays.equals(this.taps, multiTap.taps);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.taps != null ? Arrays.hashCode(this.taps) : 0);
        return result;
    }

    public String toString() {
        return "MultiTap[" + (this.taps == null ? "none" : Arrays.asList(this.taps)) + ']';
    }
}

