/*
 * Decompiled with CFR 0.152.
 */
package cascading.pipe.cogroup;

import cascading.pipe.cogroup.Joiner;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.util.Arrays;
import java.util.Iterator;

public class GroupClosure {
    final Fields[] groupingFields;
    final Fields[] valueFields;
    Tuple grouping;
    Iterator values;

    public GroupClosure(Fields[] groupingFields, Fields[] valueFields) {
        this.groupingFields = Arrays.copyOf(groupingFields, groupingFields.length);
        this.valueFields = Arrays.copyOf(valueFields, valueFields.length);
    }

    public int size() {
        return 1;
    }

    public Tuple getGrouping() {
        return this.grouping;
    }

    public Iterator getIterator(int pos) {
        if (pos != 0) {
            throw new IllegalArgumentException("invalid group position: " + pos);
        }
        return this.makeIterator(0, this.values);
    }

    protected Iterator<Tuple> makeIterator(final int pos, final Iterator values) {
        return new Iterator<Tuple>(){
            final int cleanPos;
            {
                this.cleanPos = GroupClosure.this.valueFields.length == 1 ? 0 : pos;
            }

            @Override
            public boolean hasNext() {
                return values.hasNext();
            }

            @Override
            public Tuple next() {
                Tuple tuple = (Tuple)values.next();
                tuple.set(GroupClosure.this.valueFields[this.cleanPos], GroupClosure.this.groupingFields[this.cleanPos], GroupClosure.this.grouping);
                return tuple;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    public void reset(Joiner joiner, Tuple grouping, Iterator values) {
        this.grouping = grouping;
        this.values = values;
    }
}

