/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.Tuples;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public class Identity
extends BaseOperation
implements Function {
    private Class[] types = null;

    public Identity() {
        super(Fields.ARGS);
    }

    @ConstructorProperties(value={"types"})
    public Identity(Class ... types) {
        super(Fields.ARGS);
        this.types = Arrays.copyOf(types, types.length);
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public Identity(Fields fieldDeclaration) {
        super(fieldDeclaration);
    }

    @ConstructorProperties(value={"fieldDeclaration", "types"})
    public Identity(Fields fieldDeclaration, Class ... types) {
        super(fieldDeclaration);
        this.types = Arrays.copyOf(types, types.length);
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != types.length) {
            throw new IllegalArgumentException("fieldDeclaration and types must be the same size");
        }
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        TupleEntry input = functionCall.getArguments();
        TupleEntryCollector outputCollector = functionCall.getOutputCollector();
        if (this.types == null || this.types.length == 0) {
            outputCollector.add(input);
        } else {
            outputCollector.add(Tuples.coerce(input.getTuple(), this.types));
        }
    }
}

