/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.CascadingException;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.StepCounters;
import cascading.flow.stack.MapperStackElement;
import cascading.flow.stack.StackException;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.Tuples;
import java.io.IOException;
import org.apache.hadoop.mapred.OutputCollector;

class SinkMapperStackElement
extends MapperStackElement {
    private final Tap sink;
    private OutputCollector outputCollector;

    public SinkMapperStackElement(MapperStackElement previous, FlowProcess flowProcess, Scope incomingScope, String trapName, Tap trap, Tap sink, boolean useTapCollector) throws IOException {
        super(previous, flowProcess, incomingScope, trapName, trap);
        this.sink = sink;
        if (useTapCollector) {
            this.outputCollector = (OutputCollector)sink.openForWrite(this.getJobConf());
        }
    }

    @Override
    protected FlowElement getFlowElement() {
        return this.sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(Tuple tuple) {
        super.collect(tuple);
        TupleEntry tupleEntry = null;
        try {
            tupleEntry = this.getTupleEntry(tuple);
            this.operateSink(tupleEntry);
        }
        catch (Exception exception) {
            this.handleException(exception, tupleEntry);
        }
        finally {
            Tuples.asModifiable(tuple);
        }
    }

    private void operateSink(TupleEntry tupleEntry) {
        try {
            if (this.outputCollector != null) {
                this.getFlowProcess().keepAlive();
                this.sink.sink(tupleEntry, this.outputCollector);
            } else {
                this.sink.sink(tupleEntry, this.lastOutput);
            }
            this.getFlowProcess().increment(StepCounters.Tuples_Written, 1);
        }
        catch (OutOfMemoryError error) {
            throw new StackException("out of memory, try increasing task memory allocation", error);
        }
        catch (IOException exception) {
            throw new StackException("io exception writing to tap: " + this.sink.toString(), exception);
        }
        catch (TapException exception) {
            throw new StackException("exception writing to tap: " + this.sink.toString(), exception);
        }
        catch (Throwable throwable) {
            if (throwable instanceof CascadingException) {
                throw (CascadingException)throwable;
            }
            throw new FlowException("internal error: " + tupleEntry.getTuple().print(), throwable);
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.outputCollector != null) {
                ((TupleEntryCollector)this.outputCollector).close();
            }
        }
    }
}

