/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;

public class HadoopFlowProcess
extends FlowProcess {
    JobConf jobConf;
    private boolean isMapper;
    Reporter reporter;

    public HadoopFlowProcess(FlowSession flowSession, JobConf jobConf, boolean isMapper) {
        super(flowSession);
        this.jobConf = jobConf;
        this.isMapper = isMapper;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    public boolean isMapper() {
        return this.isMapper;
    }

    public int getCurrentNumMappers() {
        return this.getJobConf().getNumMapTasks();
    }

    public int getCurrentNumReducers() {
        return this.getJobConf().getNumReduceTasks();
    }

    public int getCurrentTaskNum() {
        return this.getJobConf().getInt("mapred.task.partition", 0);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public Object getProperty(String key) {
        return this.jobConf.get(key);
    }

    @Override
    public void keepAlive() {
        this.reporter.progress();
    }

    @Override
    public void increment(Enum counter, int amount) {
        this.reporter.incrCounter(counter, (long)amount);
    }

    @Override
    public void increment(String group, String counter, int amount) {
        this.reporter.incrCounter(group, counter, (long)amount);
    }

    @Override
    public void setStatus(String status) {
        this.reporter.setStatus(status);
    }

    @Override
    public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
        return tap.openForRead(this.getJobConf());
    }

    @Override
    public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
        return tap.openForWrite(this.getJobConf());
    }
}

