/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.CascadingException;
import cascading.flow.Flow;
import cascading.flow.MultiMapReducePlanner;
import cascading.operation.AssertionLevel;
import cascading.operation.DebugLevel;
import cascading.pipe.Pipe;
import cascading.scheme.SequenceFile;
import cascading.tap.Tap;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FlowConnector {
    private Map<Object, Object> properties;

    public static void setAssertionLevel(Map<Object, Object> properties, AssertionLevel assertionLevel) {
        if (assertionLevel != null) {
            properties.put("cascading.flowconnector.assertionlevel", assertionLevel.toString());
        }
    }

    public static AssertionLevel getAssertionLevel(Map<Object, Object> properties) {
        String assertionLevel = Util.getProperty(properties, "cascading.flowconnector.assertionlevel", AssertionLevel.STRICT.name());
        return AssertionLevel.valueOf(assertionLevel);
    }

    public static void setDebugLevel(Map<Object, Object> properties, DebugLevel debugLevel) {
        if (debugLevel != null) {
            properties.put("cascading.flowconnector.debuglevel", debugLevel.toString());
        }
    }

    public static DebugLevel getDebugLevel(Map<Object, Object> properties) {
        String debugLevel = Util.getProperty(properties, "cascading.flowconnector.debuglevel", DebugLevel.DEFAULT.name());
        return DebugLevel.valueOf(debugLevel);
    }

    public static void setIntermediateSchemeClass(Map<Object, Object> properties, Class intermediateSchemeClass) {
        properties.put("cascading.flowconnector.intermediateschemeclass", intermediateSchemeClass);
    }

    public static void setIntermediateSchemeClass(Map<Object, Object> properties, String intermediateSchemeClass) {
        properties.put("cascading.flowconnector.intermediateschemeclass", intermediateSchemeClass);
    }

    public static Class getIntermediateSchemeClass(Map<Object, Object> properties) {
        Object type = Util.getProperty(properties, "cascading.flowconnector.intermediateschemeclass", null);
        if (type == null) {
            return SequenceFile.class;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        try {
            return FlowConnector.class.getClassLoader().loadClass(type.toString());
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + type.toString(), exception);
        }
    }

    public static void setApplicationJarClass(Map<Object, Object> properties, Class type) {
        if (type != null) {
            properties.put("cascading.flowconnector.appjar.class", type);
        }
    }

    public static Class getApplicationJarClass(Map<Object, Object> properties) {
        return Util.getProperty(properties, "cascading.flowconnector.appjar.class", null);
    }

    public static void setApplicationJarPath(Map<Object, Object> properties, String path) {
        if (path != null) {
            properties.put("cascading.flowconnector.appjar.path", path);
        }
    }

    public static String getApplicationJarPath(Map<Object, Object> properties) {
        return Util.getProperty(properties, "cascading.flowconnector.appjar.path", null);
    }

    public FlowConnector() {
    }

    @ConstructorProperties(value={"properties"})
    public FlowConnector(Map<Object, Object> properties) {
        this.properties = properties;
    }

    public Map<Object, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Flow connect(Tap source, Tap sink, Pipe tail) {
        return this.connect(null, source, sink, tail);
    }

    public Flow connect(String name, Tap source, Tap sink, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source);
        return this.connect(name, sources, sink, tail);
    }

    public Flow connect(String name, Tap source, Tap sink, Tap trap, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source);
        HashMap<String, Tap> traps = new HashMap<String, Tap>();
        traps.put(tail.getHeads()[0].getName(), trap);
        return this.connect(name, sources, sink, traps, tail);
    }

    public Flow connect(Map<String, Tap> sources, Tap sink, Pipe tail) {
        return this.connect(null, sources, sink, tail);
    }

    public Flow connect(String name, Map<String, Tap> sources, Tap sink, Pipe tail) {
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink);
        return this.connect(name, sources, sinks, tail);
    }

    public Flow connect(String name, Map<String, Tap> sources, Tap sink, Map<String, Tap> traps, Pipe tail) {
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink);
        return this.connect(name, sources, sinks, traps, tail);
    }

    public Flow connect(String name, Tap source, Tap sink, Map<String, Tap> traps, Pipe tail) {
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put(tail.getHeads()[0].getName(), source);
        HashMap<String, Tap> sinks = new HashMap<String, Tap>();
        sinks.put(tail.getName(), sink);
        return this.connect(name, sources, sinks, traps, tail);
    }

    public Flow connect(Tap source, Map<String, Tap> sinks, Pipe ... tails) {
        return this.connect(null, source, sinks, tails);
    }

    public Flow connect(String name, Tap source, Map<String, Tap> sinks, Pipe ... tails) {
        HashSet heads = new HashSet();
        for (Pipe pipe : tails) {
            Collections.addAll(heads, pipe.getHeads());
        }
        if (heads.isEmpty()) {
            throw new IllegalArgumentException("no pipe instance found");
        }
        if (heads.size() != 1) {
            throw new IllegalArgumentException("there may be only 1 head pipe instance, found " + heads.size());
        }
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        for (Pipe pipe : heads) {
            sources.put(pipe.getName(), source);
        }
        return this.connect(name, sources, sinks, tails);
    }

    public Flow connect(Map<String, Tap> sources, Map<String, Tap> sinks, Pipe ... tails) {
        return this.connect(null, sources, sinks, tails);
    }

    public Flow connect(String name, Map<String, Tap> sources, Map<String, Tap> sinks, Pipe ... tails) {
        return this.connect(name, sources, sinks, new HashMap<String, Tap>(), tails);
    }

    public Flow connect(String name, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Pipe ... tails) {
        name = name == null ? this.makeName(tails) : name;
        return new MultiMapReducePlanner(this.properties).buildFlow(name, tails, sources, sinks, traps);
    }

    private String makeName(Pipe[] pipes) {
        Object[] names = new String[pipes.length];
        for (int i = 0; i < pipes.length; ++i) {
            names[i] = pipes[i].getName();
        }
        String name = Util.join(names, "+");
        if (name.length() > 32) {
            name = name.substring(0, 32);
        }
        return name;
    }
}

