/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.tuple.hadoop.SerializationToken;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

@SerializationToken(tokens={126}, classNames={"[B"})
public class BytesSerialization
extends Configured
implements Serialization<byte[]> {
    public boolean accept(Class<?> c) {
        return byte[].class == c;
    }

    public Serializer<byte[]> getSerializer(Class<byte[]> c) {
        return new RawBytesSerializer();
    }

    public Deserializer<byte[]> getDeserializer(Class<byte[]> c) {
        return new RawBytesDeserializer();
    }

    public static class RawBytesSerializer
    implements Serializer<byte[]> {
        private DataOutputStream out;

        public void open(OutputStream out) throws IOException {
            this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        }

        public void serialize(byte[] bytes) throws IOException {
            this.out.writeInt(bytes.length);
            this.out.write(bytes);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class RawBytesDeserializer
    implements Deserializer<byte[]> {
        private DataInputStream in;

        public void open(InputStream in) throws IOException {
            this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        }

        public byte[] deserialize(byte[] testText) throws IOException {
            int len = this.in.readInt();
            byte[] bytes = new byte[len];
            this.in.readFully(bytes);
            return bytes;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

