/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.IndexTuple;
import cascading.tuple.Tuple;
import cascading.tuple.TupleInputStream;
import cascading.tuple.TuplePair;
import cascading.tuple.hadoop.TupleSerialization;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.WritableUtils;
import org.apache.log4j.Logger;

public class TupleOutputStream
extends DataOutputStream {
    private static final Logger LOG = Logger.getLogger(TupleInputStream.class);
    public static final int WRITABLE_TOKEN = 32;
    private static Map<Class, TupleElementWriter> tupleElementWriters = new IdentityHashMap<Class, TupleElementWriter>();
    ElementWriter elementWriter;

    public TupleOutputStream(OutputStream outputStream, ElementWriter elementWriter) {
        super(outputStream);
        this.elementWriter = elementWriter;
    }

    public TupleOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.elementWriter = new TupleSerialization().getElementWriter();
    }

    public void writeTuple(Tuple tuple) throws IOException {
        this.write(tuple);
    }

    public void writeTuplePair(TuplePair tuplePair) throws IOException {
        Tuple[] tuples = TuplePair.tuples(tuplePair);
        this.write(tuples[0]);
        this.write(tuples[1]);
    }

    public void writeIndexTuple(IndexTuple indexTuple) throws IOException {
        WritableUtils.writeVInt((DataOutput)this, (int)indexTuple.getIndex());
        this.writeTuple(indexTuple.getTuple());
    }

    private void write(Tuple tuple) throws IOException {
        List<Object> elements = Tuple.elements(tuple);
        WritableUtils.writeVInt((DataOutput)this, (int)elements.size());
        for (Object element : elements) {
            if (element == null) {
                WritableUtils.writeVInt((DataOutput)this, (int)0);
                continue;
            }
            Class<?> type = element.getClass();
            TupleElementWriter tupleElementWriter = tupleElementWriters.get(type);
            if (tupleElementWriter != null) {
                tupleElementWriter.write(this, element);
                continue;
            }
            this.elementWriter.write(this, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"closing tuple output stream");
        }
        try {
            super.close();
        }
        finally {
            if (this.elementWriter != null) {
                this.elementWriter.close();
            }
        }
    }

    static {
        tupleElementWriters.put(String.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)1);
                WritableUtils.writeString((DataOutput)stream, (String)((String)element));
            }
        });
        tupleElementWriters.put(Float.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)2);
                stream.writeFloat(((Float)element).floatValue());
            }
        });
        tupleElementWriters.put(Double.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)3);
                stream.writeDouble((Double)element);
            }
        });
        tupleElementWriters.put(Integer.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)4);
                WritableUtils.writeVInt((DataOutput)stream, (int)((Integer)element));
            }
        });
        tupleElementWriters.put(Long.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)5);
                WritableUtils.writeVLong((DataOutput)stream, (long)((Long)element));
            }
        });
        tupleElementWriters.put(Boolean.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)6);
                stream.writeBoolean((Boolean)element);
            }
        });
        tupleElementWriters.put(Short.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)7);
                stream.writeShort(((Short)element).shortValue());
            }
        });
        tupleElementWriters.put(Tuple.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)8);
                stream.writeTuple((Tuple)element);
            }
        });
        tupleElementWriters.put(TuplePair.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)9);
                stream.writeTuplePair((TuplePair)element);
            }
        });
        tupleElementWriters.put(IndexTuple.class, new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)10);
                stream.writeIndexTuple((IndexTuple)element);
            }
        });
    }

    public static interface ElementWriter {
        public void write(DataOutputStream var1, Object var2) throws IOException;

        public void close();
    }

    private static interface TupleElementWriter {
        public void write(TupleOutputStream var1, Object var2) throws IOException;
    }
}

