/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;

public class ZipSplit
extends FileSplit {
    private String entryPath;

    ZipSplit() {
        super(null, 0L, 0L, (String[])null);
    }

    public ZipSplit(Path file, String entryPath, long length) {
        super(file, 0L, length, (String[])null);
        this.entryPath = entryPath;
    }

    public ZipSplit(Path file, long length) {
        super(file, 0L, length, (String[])null);
    }

    public String getEntryPath() {
        return this.entryPath;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        WritableUtils.writeString((DataOutput)out, (String)(this.entryPath == null ? "" : this.entryPath));
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.entryPath = WritableUtils.readString((DataInput)in);
    }
}

