/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.scheme.Scheme;
import cascading.scheme.SequenceFile;
import cascading.tap.CompositeTap;
import cascading.tap.SinkTap;
import cascading.tap.Tap;
import cascading.tap.hadoop.MultiInputFormat;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.log4j.Logger;

public class MultiSinkTap
extends SinkTap
implements CompositeTap {
    private static final Logger LOG = Logger.getLogger(MultiSinkTap.class);
    private Tap[] taps;
    private String tempPath = "__multisink_placeholder" + Integer.toString((int)((double)System.currentTimeMillis() * Math.random()));
    private List<Map<String, String>> childConfigs;

    @ConstructorProperties(value={"taps"})
    public MultiSinkTap(Tap ... taps) {
        this.taps = taps;
    }

    protected Tap[] getTaps() {
        return this.taps;
    }

    @Override
    public Tap[] getChildTaps() {
        return Arrays.copyOf(this.taps, this.taps.length);
    }

    @Override
    public boolean isWriteDirect() {
        return true;
    }

    @Override
    public Path getPath() {
        return new Path(this.tempPath);
    }

    @Override
    public TupleEntryCollector openForWrite(JobConf conf) throws IOException {
        return new MultiSinkCollector(conf, this.getTaps());
    }

    @Override
    public void sinkInit(JobConf conf) throws IOException {
        this.childConfigs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.getTaps().length; ++i) {
            Tap tap = this.getTaps()[i];
            JobConf jobConf = new JobConf((Configuration)conf);
            tap.sinkInit(jobConf);
            this.childConfigs.add(MultiInputFormat.getConfig(conf, jobConf));
        }
    }

    @Override
    public boolean makeDirs(JobConf conf) throws IOException {
        for (Tap tap : this.getTaps()) {
            if (tap.makeDirs(conf)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean deletePath(JobConf conf) throws IOException {
        for (Tap tap : this.getTaps()) {
            if (tap.deletePath(conf)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean pathExists(JobConf conf) throws IOException {
        for (Tap tap : this.getTaps()) {
            if (tap.pathExists(conf)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getPathModified(JobConf conf) throws IOException {
        long modified = this.getTaps()[0].getPathModified(conf);
        for (int i = 1; i < this.getTaps().length; ++i) {
            modified = Math.max(this.getTaps()[i].getPathModified(conf), modified);
        }
        return modified;
    }

    @Override
    public void sink(TupleEntry tupleEntry, OutputCollector outputCollector) throws IOException {
        for (int i = 0; i < this.taps.length; ++i) {
            this.taps[i].sink(tupleEntry, ((MultiSinkCollector)outputCollector).collectors[i]);
        }
    }

    @Override
    public Scheme getScheme() {
        if (super.getScheme() != null) {
            return super.getScheme();
        }
        LinkedHashSet<Comparable> fieldNames = new LinkedHashSet<Comparable>();
        for (int i = 0; i < this.getTaps().length; ++i) {
            for (Comparable o : this.getTaps()[i].getSinkFields()) {
                fieldNames.add(o);
            }
        }
        Fields allFields = new Fields(fieldNames.toArray(new Comparable[fieldNames.size()]));
        this.setScheme(new SequenceFile(allFields));
        return super.getScheme();
    }

    public String toString() {
        return "MultiSinkTap[" + (this.taps == null ? "none" : Arrays.asList(this.taps)) + ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiSinkTap)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiSinkTap that = (MultiSinkTap)o;
        return Arrays.equals(this.taps, that.taps);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.taps != null ? Arrays.hashCode(this.taps) : 0);
        return result;
    }

    private class MultiSinkCollector
    extends TupleEntryCollector
    implements OutputCollector {
        OutputCollector[] collectors;

        public MultiSinkCollector(JobConf conf, Tap ... taps) throws IOException {
            this.collectors = new OutputCollector[taps.length];
            conf = new JobConf((Configuration)conf);
            JobConf[] jobConfs = MultiInputFormat.getJobConfs(conf, MultiSinkTap.this.childConfigs);
            for (int i = 0; i < taps.length; ++i) {
                Tap tap = taps[i];
                LOG.info((Object)("opening for write: " + tap.toString()));
                this.collectors[i] = (OutputCollector)tap.openForWrite(jobConfs[i]);
            }
        }

        @Override
        protected void collect(Tuple tuple) {
            throw new UnsupportedOperationException("collect should never be called on MultiSinkCollector");
        }

        public void collect(Object key, Object value) throws IOException {
            for (OutputCollector collector : this.collectors) {
                collector.collect(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            super.close();
            try {
                for (OutputCollector collector : this.collectors) {
                    try {
                        ((TupleEntryCollector)collector).close();
                    }
                    catch (Exception exception) {
                        LOG.warn((Object)"exception closing TupleEntryCollector", (Throwable)exception);
                    }
                }
            }
            finally {
                this.collectors = null;
            }
        }
    }
}

