/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.scheme.Scheme;
import cascading.tap.Hfs;
import cascading.tap.SinkMode;
import cascading.tuple.Fields;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;

public class Lfs
extends Hfs {
    @ConstructorProperties(value={"scheme"})
    Lfs(Scheme scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"fields", "stringPath"})
    public Lfs(Fields fields, String stringPath) {
        super(fields, stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Lfs(Scheme scheme, String stringPath) {
        super(scheme, stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "replace"})
    public Lfs(Scheme scheme, String stringPath, boolean replace) {
        super(scheme, stringPath, replace);
    }

    @ConstructorProperties(value={"fields", "stringPath", "sinkMode"})
    public Lfs(Fields fields, String stringPath, SinkMode sinkMode) {
        super(fields, stringPath, sinkMode);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Lfs(Scheme scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, stringPath, sinkMode);
    }

    @Override
    protected void setStringPath(String stringPath) {
        if (stringPath.matches(".*://.*") && !stringPath.startsWith("file://")) {
            throw new IllegalArgumentException("uri must use the file scheme");
        }
        super.setStringPath(stringPath);
    }

    @Override
    protected FileSystem getFileSystem(JobConf conf) throws IOException {
        return FileSystem.getLocal((Configuration)conf);
    }
}

