/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stack;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.Scope;
import cascading.flow.stack.ReducerStackElement;
import cascading.flow.stack.StackElement;
import cascading.pipe.Each;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import java.util.Iterator;

class EachReducerStackElement
extends ReducerStackElement {
    private final Each each;
    private Each.EachHandler eachHandler;

    public EachReducerStackElement(StackElement previous, FlowProcess flowProcess, Scope incomingScope, Tap trap, Each each) {
        super(previous, flowProcess, incomingScope, each.getName(), trap);
        this.each = each;
    }

    @Override
    public FlowElement getFlowElement() {
        return this.each;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    StackElement setNext(StackElement next) {
        try {
            StackElement stackElement = super.setNext(next);
            return stackElement;
        }
        finally {
            this.eachHandler = this.each.getHandler(next, ((ReducerStackElement)next).getIncomingScope());
        }
    }

    @Override
    public void prepare() {
        this.eachHandler.prepare(this.flowProcess);
    }

    @Override
    public void cleanup() {
        this.eachHandler.cleanup(this.flowProcess);
    }

    @Override
    public void collect(Tuple key, Iterator values) {
        this.operateEach(key, values);
    }

    @Override
    public void collect(Tuple tuple) {
        this.operateEach(this.getTupleEntry(tuple));
    }

    private void operateEach(Tuple key, Iterator values) {
        while (values.hasNext()) {
            this.operateEach((TupleEntry)values.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void operateEach(TupleEntry tupleEntry) {
        try {
            this.eachHandler.operate(this.flowProcess, tupleEntry);
        }
        catch (Exception exception) {
            this.handleException(exception, tupleEntry);
        }
        finally {
            Tuples.asModifiable(tupleEntry.getTuple());
        }
    }
}

