package cascading.kryo;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

/** User: sritchie Date: 12/1/11 Time: 11:43 AM */
public class KryoSerialization extends Configured implements Serialization<Object> {
    public static final Logger LOG = Logger.getLogger(KryoSerialization.class);

    Kryo kryo;
    KryoFactory factory;

    public KryoSerialization() {
    }

    /**
     * Constructor KryoSerialization creates a new KryoSerialization instance.
     *
     * @param conf of type Configuration
     */
    public KryoSerialization( Configuration conf ) {
        super( conf );
    }

    /**
     * Entry point into Cascading.Kryo customization. Subclass this to bootstrap the serialization's
     * Kryo instance with anything your heart desires.
     * @param k
     * @return
     */
    public Kryo decorateKryo(Kryo k) {
        return k;
    }

    @Override public Configuration getConf() {
        if( super.getConf() == null )
            setConf( new JobConf() );
        return super.getConf();
    }


    public final Kryo populatedKryo() {
        Kryo k = new Kryo();
        decorateKryo(k);
        factory.populateKryo(k);
        return k;
    }

    /**
     * Initializes Kryo instance from the JobConf on the first run. If the ACCEPT_ALL key in
     * the JobConf has been set to true, Kryo will return yes for everything; else, Kryo will only
     * return true for classes with explicitly registered serializations.
     * @param aClass
     * @return
     */
    public boolean accept(Class<?> aClass) {
        if (factory == null) {
            factory = new KryoFactory((JobConf) getConf());
            kryo = populatedKryo();
        }
        try {
            return (kryo.getRegisteredClass(aClass) != null);
        } catch (IllegalArgumentException e) {
            return factory.getAcceptAll();
        }
    }

    public Serializer<Object> getSerializer(Class aClass) {
        return new KryoSerializer(populatedKryo());
    }

    public Deserializer<Object> getDeserializer(Class aClass) {
        return new KryoDeserializer(populatedKryo(), aClass);
    }
}
