/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.AsynchronousTransport;
import com.aphyr.riemann.client.CachingResolver;
import com.aphyr.riemann.client.ChannelGroupHandler;
import com.aphyr.riemann.client.ExceptionReporter;
import com.aphyr.riemann.client.Promise;
import com.aphyr.riemann.client.ReconnectHandler;
import com.aphyr.riemann.client.Resolver;
import com.aphyr.riemann.client.TcpHandler;
import com.aphyr.riemann.client.Write;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransport
implements AsynchronousTransport {
    public final Logger logger = LoggerFactory.getLogger(TcpTransport.class);
    public static final ProtobufDecoder pbDecoder = new ProtobufDecoder((MessageLite)Proto.Msg.getDefaultInstance());
    public static final ProtobufEncoder pbEncoder = new ProtobufEncoder();
    public static final LengthFieldPrepender frameEncoder = new LengthFieldPrepender(4);
    public static final int DEFAULT_PORT = 5555;
    public volatile State state = State.DISCONNECTED;
    public final ChannelGroup channels = new DefaultChannelGroup();
    public volatile Timer timer;
    public volatile ClientBootstrap bootstrap;
    public final AtomicLong reconnectDelay = new AtomicLong(5000L);
    public final AtomicLong connectTimeout = new AtomicLong(5000L);
    public final AtomicInteger maxInflightRequests = new AtomicInteger(2048);
    public final AtomicBoolean cacheDns = new AtomicBoolean(true);
    public final InetSocketAddress address;
    public final AtomicReference<SSLContext> sslContext = new AtomicReference();
    public volatile ExceptionReporter exceptionReporter = new ExceptionReporter(){

        @Override
        public void reportException(Throwable t) {
            TcpTransport.this.logger.warn("caught", t);
        }
    };

    public void setExceptionReporter(ExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
    }

    public TcpTransport(InetSocketAddress address) {
        this.address = address;
    }

    public TcpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public TcpTransport(String host) throws IOException {
        this(host, 5555);
    }

    public TcpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Override
    public boolean isConnected() {
        if (this.state != State.CONNECTED) {
            return false;
        }
        for (Channel ch : this.channels) {
            if (!ch.isConnected()) continue;
            return true;
        }
        return false;
    }

    public SslHandler sslHandler() {
        SSLContext context = this.sslContext.get();
        if (context == null) {
            return null;
        }
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(true);
        SslHandler handler = new SslHandler(engine);
        handler.setEnableRenegotiation(false);
        handler.setIssueHandshake(true);
        return handler;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.state != State.DISCONNECTED) {
            return;
        }
        this.state = State.CONNECTING;
        NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.timer = new HashedWheelTimer();
        this.bootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline p = Channels.pipeline();
                p.addLast("reconnect", (ChannelHandler)new ReconnectHandler(TcpTransport.this.bootstrap, TcpTransport.this.timer, TcpTransport.this.reconnectDelay, TimeUnit.MILLISECONDS));
                SslHandler sslHandler = TcpTransport.this.sslHandler();
                if (sslHandler != null) {
                    p.addLast("tls", (ChannelHandler)sslHandler);
                }
                p.addLast("frame-decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
                p.addLast("frame-encoder", (ChannelHandler)frameEncoder);
                p.addLast("protobuf-decoder", (ChannelHandler)pbDecoder);
                p.addLast("protobuf-encoder", (ChannelHandler)pbEncoder);
                p.addLast("channelgroups", (ChannelHandler)new ChannelGroupHandler(TcpTransport.this.channels));
                p.addLast("handler", (ChannelHandler)new TcpHandler(TcpTransport.this.exceptionReporter, TcpTransport.this.maxInflightRequests));
                return p;
            }
        });
        Resolver resolver = this.cacheDns.get() ? new CachingResolver(this.address) : new Resolver(this.address);
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.bootstrap.setOption("resolver", (Object)resolver);
        this.bootstrap.setOption("remoteAddress", (Object)resolver.resolve());
        ChannelFuture result = this.bootstrap.connect().awaitUninterruptibly();
        this.state = State.CONNECTED;
        if (!result.isSuccess()) {
            throw new IOException("Connection failed", result.getCause());
        }
    }

    @Override
    public void disconnect() throws IOException {
        this.disconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean force) throws IOException {
        if (!force && this.state != State.CONNECTED) {
            return;
        }
        try {
            this.timer.stop();
            this.channels.close().awaitUninterruptibly();
            this.bootstrap.releaseExternalResources();
        }
        finally {
            this.timer = null;
            this.bootstrap = null;
            this.state = State.DISCONNECTED;
        }
    }

    @Override
    public void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
    }

    public Promise<Proto.Msg> write(Proto.Msg msg, Promise<Proto.Msg> promise) {
        if (this.state == State.CONNECTED) {
            Write write = new Write(msg, promise);
            Iterator i$ = this.channels.iterator();
            if (i$.hasNext()) {
                Channel channel = (Channel)i$.next();
                channel.write((Object)new Write(msg, promise));
                return promise;
            }
            promise.deliver(new IOException("No channels available."));
        } else {
            promise.deliver(new IOException("Not connected."));
        }
        return promise;
    }

    public Promise<Proto.Msg> aSendRecvMessage(Proto.Msg msg) {
        return this.write(msg, new Promise<Proto.Msg>());
    }

    public Promise<Proto.Msg> aSendMaybeRecvMessage(Proto.Msg msg) {
        return this.aSendRecvMessage(msg);
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

