/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.MetricsRegistryListener;
import com.yammer.metrics.reporting.AbstractReporter;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxReporter
extends AbstractReporter
implements MetricsRegistryListener,
MetricProcessor<Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxReporter.class);
    private final Map<MetricName, ObjectName> registeredBeans = new ConcurrentHashMap<MetricName, ObjectName>(100);
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private static JmxReporter INSTANCE;

    public static void startDefault(MetricsRegistry registry) {
        INSTANCE = new JmxReporter(registry);
        INSTANCE.start();
    }

    public static JmxReporter getDefault() {
        return INSTANCE;
    }

    public static void shutdownDefault() {
        if (INSTANCE != null) {
            INSTANCE.shutdown();
        }
    }

    public JmxReporter(MetricsRegistry registry) {
        super(registry);
    }

    public void onMetricAdded(MetricName name, Metric metric) {
        if (metric != null) {
            try {
                metric.processWith((MetricProcessor)this, name, (Object)new Context(name, new ObjectName(name.getMBeanName())));
            }
            catch (Exception e) {
                LOGGER.warn("Error processing {}", (Object)name, (Object)e);
            }
        }
    }

    public void onMetricRemoved(MetricName name) {
        ObjectName objectName = this.registeredBeans.remove(name);
        if (objectName != null) {
            this.unregisterBean(objectName);
        }
    }

    public void processMeter(MetricName name, Metered meter, Context context) throws Exception {
        this.registerBean(context.getMetricName(), new Meter(meter, context.getObjectName()), context.getObjectName());
    }

    public void processCounter(MetricName name, com.yammer.metrics.core.Counter counter, Context context) throws Exception {
        this.registerBean(context.getMetricName(), new Counter(counter, context.getObjectName()), context.getObjectName());
    }

    public void processHistogram(MetricName name, com.yammer.metrics.core.Histogram histogram, Context context) throws Exception {
        this.registerBean(context.getMetricName(), new Histogram(histogram, context.getObjectName()), context.getObjectName());
    }

    public void processTimer(MetricName name, com.yammer.metrics.core.Timer timer, Context context) throws Exception {
        this.registerBean(context.getMetricName(), new Timer(timer, context.getObjectName()), context.getObjectName());
    }

    public void processGauge(MetricName name, com.yammer.metrics.core.Gauge<?> gauge, Context context) throws Exception {
        this.registerBean(context.getMetricName(), new Gauge(gauge, context.getObjectName()), context.getObjectName());
    }

    @Override
    public void shutdown() {
        this.getMetricsRegistry().removeListener((MetricsRegistryListener)this);
        for (ObjectName name : this.registeredBeans.values()) {
            this.unregisterBean(name);
        }
        this.registeredBeans.clear();
    }

    public final void start() {
        this.getMetricsRegistry().addListener((MetricsRegistryListener)this);
    }

    private void registerBean(MetricName name, MetricMBean bean, ObjectName objectName) throws MBeanRegistrationException, OperationsException {
        this.server.registerMBean(bean, objectName);
        this.registeredBeans.put(name, objectName);
    }

    private void unregisterBean(ObjectName name) {
        try {
            this.server.unregisterMBean(name);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.trace("Error unregistering {}", (Object)name, (Object)e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.debug("Error unregistering {}", (Object)name, (Object)e);
        }
    }

    static final class Context {
        private final MetricName metricName;
        private final ObjectName objectName;

        public Context(MetricName metricName, ObjectName objectName) {
            this.metricName = metricName;
            this.objectName = objectName;
        }

        MetricName getMetricName() {
            return this.metricName;
        }

        ObjectName getObjectName() {
            return this.objectName;
        }
    }

    static class Timer
    extends Meter
    implements TimerMBean {
        private final com.yammer.metrics.core.Timer metric;

        private Timer(com.yammer.metrics.core.Timer metric, ObjectName objectName) {
            super((Metered)metric, objectName);
            this.metric = metric;
        }

        @Override
        public double get50thPercentile() {
            return this.metric.getSnapshot().getMedian();
        }

        @Override
        public TimeUnit getLatencyUnit() {
            return this.metric.durationUnit();
        }

        @Override
        public double getMin() {
            return this.metric.min();
        }

        @Override
        public double getMax() {
            return this.metric.max();
        }

        @Override
        public double getMean() {
            return this.metric.mean();
        }

        @Override
        public double getStdDev() {
            return this.metric.stdDev();
        }

        @Override
        public double get75thPercentile() {
            return this.metric.getSnapshot().get75thPercentile();
        }

        @Override
        public double get95thPercentile() {
            return this.metric.getSnapshot().get95thPercentile();
        }

        @Override
        public double get98thPercentile() {
            return this.metric.getSnapshot().get98thPercentile();
        }

        @Override
        public double get99thPercentile() {
            return this.metric.getSnapshot().get99thPercentile();
        }

        @Override
        public double get999thPercentile() {
            return this.metric.getSnapshot().get999thPercentile();
        }

        @Override
        public double[] values() {
            return this.metric.getSnapshot().getValues();
        }
    }

    public static interface TimerMBean
    extends MeterMBean,
    HistogramMBean {
        public TimeUnit getLatencyUnit();
    }

    private static class Histogram
    implements HistogramMBean {
        private final ObjectName objectName;
        private final com.yammer.metrics.core.Histogram metric;

        private Histogram(com.yammer.metrics.core.Histogram metric, ObjectName objectName) {
            this.metric = metric;
            this.objectName = objectName;
        }

        @Override
        public ObjectName objectName() {
            return this.objectName;
        }

        @Override
        public double get50thPercentile() {
            return this.metric.getSnapshot().getMedian();
        }

        @Override
        public long getCount() {
            return this.metric.count();
        }

        @Override
        public double getMin() {
            return this.metric.min();
        }

        @Override
        public double getMax() {
            return this.metric.max();
        }

        @Override
        public double getMean() {
            return this.metric.mean();
        }

        @Override
        public double getStdDev() {
            return this.metric.stdDev();
        }

        @Override
        public double get75thPercentile() {
            return this.metric.getSnapshot().get75thPercentile();
        }

        @Override
        public double get95thPercentile() {
            return this.metric.getSnapshot().get95thPercentile();
        }

        @Override
        public double get98thPercentile() {
            return this.metric.getSnapshot().get98thPercentile();
        }

        @Override
        public double get99thPercentile() {
            return this.metric.getSnapshot().get99thPercentile();
        }

        @Override
        public double get999thPercentile() {
            return this.metric.getSnapshot().get999thPercentile();
        }

        @Override
        public double[] values() {
            return this.metric.getSnapshot().getValues();
        }
    }

    public static interface HistogramMBean
    extends MetricMBean {
        public long getCount();

        public double getMin();

        public double getMax();

        public double getMean();

        public double getStdDev();

        public double get50thPercentile();

        public double get75thPercentile();

        public double get95thPercentile();

        public double get98thPercentile();

        public double get99thPercentile();

        public double get999thPercentile();

        public double[] values();
    }

    private static class Meter
    extends AbstractBean
    implements MeterMBean {
        private final Metered metric;

        private Meter(Metered metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public long getCount() {
            return this.metric.count();
        }

        @Override
        public String getEventType() {
            return this.metric.eventType();
        }

        @Override
        public TimeUnit getRateUnit() {
            return this.metric.rateUnit();
        }

        @Override
        public double getMeanRate() {
            return this.metric.meanRate();
        }

        @Override
        public double getOneMinuteRate() {
            return this.metric.oneMinuteRate();
        }

        @Override
        public double getFiveMinuteRate() {
            return this.metric.fiveMinuteRate();
        }

        @Override
        public double getFifteenMinuteRate() {
            return this.metric.fifteenMinuteRate();
        }
    }

    public static interface MeterMBean
    extends MetricMBean {
        public long getCount();

        public String getEventType();

        public TimeUnit getRateUnit();

        public double getMeanRate();

        public double getOneMinuteRate();

        public double getFiveMinuteRate();

        public double getFifteenMinuteRate();
    }

    private static class Counter
    extends AbstractBean
    implements CounterMBean {
        private final com.yammer.metrics.core.Counter metric;

        private Counter(com.yammer.metrics.core.Counter metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public long getCount() {
            return this.metric.count();
        }
    }

    public static interface CounterMBean
    extends MetricMBean {
        public long getCount();
    }

    private static class Gauge
    extends AbstractBean
    implements GaugeMBean {
        private final com.yammer.metrics.core.Gauge<?> metric;

        private Gauge(com.yammer.metrics.core.Gauge<?> metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public Object getValue() {
            return this.metric.value();
        }
    }

    public static interface GaugeMBean
    extends MetricMBean {
        public Object getValue();
    }

    private static abstract class AbstractBean
    implements MetricMBean {
        private final ObjectName objectName;

        protected AbstractBean(ObjectName objectName) {
            this.objectName = objectName;
        }

        @Override
        public ObjectName objectName() {
            return this.objectName;
        }
    }

    public static interface MetricMBean {
        public ObjectName objectName();
    }
}

