/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.CachingResolver;
import com.aphyr.riemann.client.Resolver;
import com.aphyr.riemann.client.SynchronousTransport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class SimpleUdpTransport
implements SynchronousTransport {
    public static final int DEFAULT_PORT = 5555;
    private volatile DatagramSocket socket;
    private volatile boolean connected = false;
    private final InetSocketAddress address;
    private volatile Resolver resolver;

    public SimpleUdpTransport(InetSocketAddress address) {
        this.address = address;
    }

    public SimpleUdpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public SimpleUdpTransport(String host) throws IOException {
        this(host, 5555);
    }

    public SimpleUdpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Override
    public Proto.Msg sendMaybeRecvMessage(Proto.Msg msg) throws IOException {
        byte[] body = msg.toByteArray();
        DatagramPacket packet = new DatagramPacket(body, body.length, this.resolver.resolve());
        this.socket.send(packet);
        return null;
    }

    @Override
    public Proto.Msg sendRecvMessage(Proto.Msg msg) throws IOException {
        throw new UnsupportedOperationException("UDP transport doesn't support receiving messages");
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void connect() throws IOException {
        this.connect(true);
    }

    @Override
    public synchronized void connect(boolean cacheDns) throws IOException {
        this.resolver = cacheDns ? new CachingResolver(this.address) : new Resolver(this.address);
        this.socket = new DatagramSocket();
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect() throws IOException {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
            this.connected = false;
        }
    }

    @Override
    public void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
    }
}

